/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.boltlistener;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;

final class ListeningBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final BoltConnectionListener boltConnectionListener;

    public ListeningBoltConnection(BoltConnection delegate, BoltConnectionListener boltConnectionListener) {
        this.delegate = Objects.requireNonNull(delegate);
        this.boltConnectionListener = Objects.requireNonNull(boltConnectionListener);
    }

    public CompletionStage<Void> writeAndFlush(ResponseHandler handler, List<Message> messages, ImmutableObservation parentObservation) {
        return this.delegate.writeAndFlush(handler, messages, parentObservation);
    }

    public CompletionStage<Void> write(List<Message> messages) {
        return this.delegate.write(messages);
    }

    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason).whenComplete((ignored, throwable) -> this.boltConnectionListener.onClose(this));
    }

    public CompletionStage<Void> close() {
        return this.delegate.close().whenComplete((ignored, throwable) -> this.boltConnectionListener.onClose(this));
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    public BoltConnectionState state() {
        return this.delegate.state();
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }
}

