/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Query;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.async.AsyncAbstractQueryRunner;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;

public class InternalAsyncTransaction
extends AsyncAbstractQueryRunner
implements AsyncTransaction {
    private final UnmanagedTransaction tx;
    private final DriverObservationProvider observationProvider;

    public InternalAsyncTransaction(UnmanagedTransaction tx, DriverObservationProvider observationProvider, Observation parentObservation) {
        this.tx = tx;
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public CompletionStage<Void> commitAsync() {
        Observation commitObservation = this.observationProvider.transactionCommit(AsyncTransaction.class);
        return ObservationUtil.observeAsync(commitObservation, () -> this.tx.commitAsync(commitObservation));
    }

    @Override
    public CompletionStage<Void> rollbackAsync() {
        Observation rollbackObservation = this.observationProvider.transactionRollback(AsyncTransaction.class);
        return ObservationUtil.observeAsync(rollbackObservation, () -> this.tx.rollbackAsync(rollbackObservation));
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        Observation closeObservation = this.observationProvider.transactionClose(AsyncTransaction.class);
        return ObservationUtil.observeAsync(closeObservation, () -> this.tx.closeAsync(closeObservation));
    }

    @Override
    public CompletionStage<Boolean> isOpenAsync() {
        return CompletableFuture.completedFuture(this.isOpen());
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query) {
        Observation runObservation = this.observationProvider.transactionRun(AsyncTransaction.class, query.text(), query.parameters());
        return ObservationUtil.observeAsync(runObservation, () -> this.tx.runAsync(query, runObservation, ResultCursor.class));
    }

    public boolean isOpen() {
        return this.tx.isOpen();
    }
}

