/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.bolt.connection.NotificationClassification;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.internal.InternalNotificationConfig;
import org.neo4j.driver.internal.InternalNotificationSeverity;

public class NotificationConfigMapper {
    public static org.neo4j.bolt.connection.NotificationConfig map(NotificationConfig config) {
        InternalNotificationConfig original = (InternalNotificationConfig)config;
        Set<NotificationCategory> disabledCategories = original.disabledCategories();
        return new org.neo4j.bolt.connection.NotificationConfig(NotificationConfigMapper.map(original.minimumSeverity()), disabledCategories != null ? disabledCategories.stream().map(NotificationConfigMapper::map).collect(Collectors.toSet()) : null);
    }

    private static org.neo4j.bolt.connection.NotificationSeverity map(NotificationSeverity severity) {
        if (severity == null) {
            return null;
        }
        InternalNotificationSeverity original = (InternalNotificationSeverity)severity;
        return switch (original.type()) {
            default -> throw new IncompatibleClassChangeError();
            case InternalNotificationSeverity.Type.INFORMATION -> org.neo4j.bolt.connection.NotificationSeverity.INFORMATION;
            case InternalNotificationSeverity.Type.WARNING -> org.neo4j.bolt.connection.NotificationSeverity.WARNING;
            case InternalNotificationSeverity.Type.OFF -> org.neo4j.bolt.connection.NotificationSeverity.OFF;
        };
    }

    private static org.neo4j.bolt.connection.NotificationClassification map(NotificationCategory category) {
        if (category == null) {
            return null;
        }
        NotificationClassification original = (NotificationClassification)category;
        return switch (original) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationClassification.HINT -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.HINT);
            case NotificationClassification.UNRECOGNIZED -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.UNRECOGNIZED);
            case NotificationClassification.UNSUPPORTED -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.UNSUPPORTED);
            case NotificationClassification.PERFORMANCE -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.PERFORMANCE);
            case NotificationClassification.DEPRECATION -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.DEPRECATION);
            case NotificationClassification.SECURITY -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.SECURITY);
            case NotificationClassification.TOPOLOGY -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.TOPOLOGY);
            case NotificationClassification.GENERIC -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.GENERIC);
            case NotificationClassification.SCHEMA -> new org.neo4j.bolt.connection.NotificationClassification(NotificationClassification.Type.SCHEMA);
        };
    }
}

