/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.bolt.connection.values.Type;
import org.neo4j.bolt.connection.values.Vector;
import org.neo4j.driver.internal.AbstractArrayVector;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ObjectValueAdapter;
import org.neo4j.driver.types.ByteVector;
import org.neo4j.driver.types.DoubleVector;
import org.neo4j.driver.types.FloatVector;
import org.neo4j.driver.types.IntVector;
import org.neo4j.driver.types.LongVector;
import org.neo4j.driver.types.ShortVector;

public class VectorValue
extends ObjectValueAdapter<org.neo4j.driver.types.Vector> {
    public VectorValue(org.neo4j.driver.types.Vector vector) {
        super(vector);
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.VECTOR();
    }

    public Type boltValueType() {
        return Type.VECTOR;
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(ByteVector.class) || targetClass.isAssignableFrom(ShortVector.class) || targetClass.isAssignableFrom(IntVector.class) || targetClass.isAssignableFrom(LongVector.class) || targetClass.isAssignableFrom(FloatVector.class) || targetClass.isAssignableFrom(DoubleVector.class)) {
            return targetClass.cast(this.asObject());
        }
        if (targetClass.isArray()) {
            AbstractArrayVector arrayVector = (AbstractArrayVector)this.asObject();
            if (targetClass.getComponentType().equals(arrayVector.elementType())) {
                return targetClass.cast(arrayVector.toArray());
            }
            throw new AssertionError((Object)("Unsupported type: " + String.valueOf(targetClass)));
        }
        return this.asMapped(targetClass);
    }

    @Override
    public Vector asBoltVector() {
        final AbstractArrayVector vector = (AbstractArrayVector)this.asObject();
        return new Vector(){

            public Class<?> elementType() {
                return vector.elementType();
            }

            public Object elements() {
                return vector.elements();
            }
        };
    }
}

