/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.BaseSession;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.ExecutableQuery;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;

public interface Driver
extends AutoCloseable {
    public ExecutableQuery executableQuery(String var1);

    public BookmarkManager executableQueryBookmarkManager();

    public boolean isEncrypted();

    default public Session session() {
        return this.session(Session.class);
    }

    default public Session session(SessionConfig sessionConfig) {
        return this.session(Session.class, sessionConfig);
    }

    default public <T extends BaseSession> T session(Class<T> sessionClass) {
        return this.session(sessionClass, SessionConfig.defaultConfig());
    }

    default public <T extends BaseSession> T session(Class<T> sessionClass, AuthToken sessionAuthToken) {
        return this.session(sessionClass, SessionConfig.defaultConfig(), sessionAuthToken);
    }

    default public <T extends BaseSession> T session(Class<T> sessionClass, SessionConfig sessionConfig) {
        return this.session(sessionClass, sessionConfig, null);
    }

    public <T extends BaseSession> T session(Class<T> var1, SessionConfig var2, AuthToken var3);

    @Override
    public void close();

    public CompletionStage<Void> closeAsync();

    public Metrics metrics();

    public boolean isMetricsEnabled();

    public void verifyConnectivity();

    public CompletionStage<Void> verifyConnectivityAsync();

    public boolean verifyAuthentication(AuthToken var1);

    public boolean supportsSessionAuth();

    public boolean supportsMultiDb();

    public CompletionStage<Boolean> supportsMultiDbAsync();
}

