/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.observation.util;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ObservationUtil {
    public static void observe(Observation observation, Runnable runnable) {
        ObservationUtil.observe(observation, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T observe(Observation observation, Supplier<T> supplier) {
        observation.start();
        try {
            T t;
            block11: {
                Observation.Scope scope = observation.openScope();
                try {
                    t = supplier.get();
                    if (scope == null) break block11;
                    scope.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        observation.error(e);
                        throw e;
                    }
                }
            }
            return t;
        }
        finally {
            observation.stop();
        }
    }

    public static <T> T scoped(DriverObservationProvider observationProvider, Observation observation, Supplier<T> supplier) {
        Observation scopedObservation = observationProvider.scopedObservation();
        if (scopedObservation == null || !scopedObservation.equals(observation)) {
            try (Observation.Scope scope = observation.openScope();){
                T t = supplier.get();
                return t;
            }
        }
        return supplier.get();
    }

    public static <T> CompletionStage<T> observeAsync(Observation observation, Supplier<CompletionStage<T>> supplier) {
        observation.start();
        return ObservationUtil.observeAsyncStarted(observation, supplier);
    }

    public static <T> CompletionStage<T> observeAsyncStarted(Observation observation, Supplier<CompletionStage<T>> supplier) {
        CompletionStage<Object> observed;
        try (Observation.Scope scope = observation.openScope();){
            observed = supplier.get();
        }
        catch (Throwable e) {
            observation.error(e);
            observation.stop();
            throw e;
        }
        return observed.whenComplete((result, throwable) -> {
            if (throwable != null) {
                observation.error(Futures.completionExceptionCause(throwable));
            }
            observation.stop();
        });
    }

    public static <T> Publisher<T> observeStreamsWithoutStart(Observation observation, Publisher<T> publisher, boolean stopOnCancel) {
        if (publisher instanceof Mono) {
            Mono mono = (Mono)publisher;
            return mono.doOnError(observation::error).doOnCancel(() -> {
                if (stopOnCancel) {
                    observation.stop();
                }
            }).doOnNext(ignored -> observation.stop());
        }
        return Flux.from(publisher).doOnError(observation::error).doOnCancel(() -> {
            if (stopOnCancel) {
                observation.stop();
            }
        }).doOnComplete(observation::stop);
    }

    public static <T> Publisher<T> observeStreams(Observation observation, Publisher<T> publisher) {
        return ObservationUtil.observeStreams(observation, publisher, true, false);
    }

    public static <T> Publisher<T> observeStreams(Observation observation, Publisher<T> publisher, boolean startOnRequest, boolean stopOnCancel) {
        if (!startOnRequest) {
            observation.start();
        }
        AtomicBoolean started = new AtomicBoolean();
        if (publisher instanceof Mono) {
            Mono mono = (Mono)publisher;
            return mono.doOnRequest(ignored -> {
                if (startOnRequest && !started.get()) {
                    observation.start();
                    started.set(true);
                }
            }).doOnError(throwable -> {
                observation.error((Throwable)throwable);
                observation.stop();
            }).doOnCancel(() -> {
                if (stopOnCancel) {
                    observation.stop();
                }
            }).doOnSuccess(ignored -> observation.stop());
        }
        return Flux.from(publisher).doOnRequest(ignored -> {
            if (startOnRequest && !started.get()) {
                observation.start();
                started.set(true);
            }
        }).doOnError(observation::error).doOnCancel(() -> {
            if (stopOnCancel) {
                observation.stop();
            }
        }).doOnComplete(observation::stop);
    }
}

