/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.Messages;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.summary.DiscardSummary;
import org.neo4j.driver.internal.adaptedbolt.summary.PullSummary;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.AbstractRecordStateResponseHandler;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.NoopObservation;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.summary.ResultSummary;

public class ResultCursorImpl
extends AbstractRecordStateResponseHandler
implements ResultCursor,
FailableCursor,
DriverResponseHandler {
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_last");
    private static final ClientException IGNORED_ERROR = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription("A message has been ignored during result streaming."), "N/A", "A message has been ignored during result streaming.", GqlStatusError.DIAGNOSTIC_RECORD, null);
    private final DriverBoltConnection boltConnection;
    private final Queue<Record> records = new ArrayDeque<Record>();
    private final Query query;
    private final long fetchSize;
    private final Consumer<DatabaseBookmark> bookmarkConsumer;
    private final boolean closeOnSummary;
    private final boolean legacyNotifications;
    private final CompletableFuture<ResultCursorImpl> resultCursorFuture = new CompletableFuture();
    private final CompletableFuture<UnmanagedTransaction> beginFuture;
    private final ApiTelemetryWork apiTelemetryWork;
    private final CompletableFuture<Void> consumedFuture = new CompletableFuture();
    private final Consumer<String> databaseNameConsumer;
    private final DriverObservationProvider observationProvider;
    private final Class<?> resultType;
    private RunSummary runSummary;
    private State state;
    private boolean apiCallInProgress;
    private CompletableFuture<Record> peekFuture;
    private CompletableFuture<Record> recordFuture;
    private CompletableFuture<Boolean> secondRecordFuture;
    private CompletableFuture<List<Record>> recordsFuture;
    private boolean keepRecords;
    private CompletableFuture<ResultSummary> summaryFuture;
    private ResultSummary summary;
    private Throwable error;
    private boolean errorExposed;
    private Observation pendingObservation;
    private boolean observeBoltOnly;

    public ResultCursorImpl(DriverBoltConnection boltConnection, Query query, long fetchSize, Consumer<DatabaseBookmark> bookmarkConsumer, boolean closeOnSummary, CompletableFuture<UnmanagedTransaction> beginFuture, Consumer<String> databaseNameConsumer, ApiTelemetryWork apiTelemetryWork, DriverObservationProvider observationProvider, Class<?> resultType) {
        this.boltConnection = Objects.requireNonNull(boltConnection);
        this.legacyNotifications = new BoltProtocolVersion(5, 5).compareTo(boltConnection.protocolVersion()) > 0;
        this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.REQUESTED);
        this.query = Objects.requireNonNull(query);
        this.fetchSize = fetchSize;
        this.bookmarkConsumer = Objects.requireNonNull(bookmarkConsumer);
        this.closeOnSummary = closeOnSummary;
        this.state = State.STREAMING;
        this.beginFuture = beginFuture;
        this.apiTelemetryWork = apiTelemetryWork;
        this.databaseNameConsumer = Objects.requireNonNull(databaseNameConsumer);
        this.observationProvider = Objects.requireNonNull(observationProvider);
        this.resultType = Objects.requireNonNull(resultType);
    }

    public CompletionStage<ResultCursorImpl> resultCursor() {
        return this.resultCursorFuture;
    }

    @Override
    public synchronized List<String> keys() {
        return this.runSummary.keys();
    }

    @Override
    public synchronized CompletionStage<ResultSummary> consumeAsync() {
        return this.consumeAsync(null);
    }

    private synchronized CompletionStage<ResultSummary> consumeAsync(Observation parentObservation) {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        CompletionStage<ResultSummary> summaryFt = switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                Observation boltObservation;
                Observation consumeObservation;
                if (parentObservation != null) {
                    consumeObservation = NoopObservation.getInstance();
                    boltObservation = parentObservation;
                } else {
                    consumeObservation = this.observationProvider.resultConsume(this.resultType).start();
                    boltObservation = consumeObservation;
                }
                this.apiCallInProgress = true;
                CompletableFuture<ResultSummary> future = this.summaryFuture = new CompletableFuture();
                this.state = State.DISCARDING;
                this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.discard((long)this.runSummary.queryId(), (long)-1L), boltObservation).whenComplete((ignored, throwable) -> {
                    Throwable error = Futures.completionExceptionCause(throwable);
                    if (error != null) {
                        CompletableFuture<ResultSummary> summaryFuture;
                        ResultCursorImpl resultCursorImpl = this;
                        synchronized (resultCursorImpl) {
                            this.state = State.FAILED;
                            this.errorExposed = true;
                            summaryFuture = this.summaryFuture;
                            this.summaryFuture = null;
                            this.apiCallInProgress = false;
                        }
                        summaryFuture.completeExceptionally(error);
                    }
                });
                yield ObservationUtil.observeAsyncStarted(consumeObservation, () -> future);
            }
            case 1 -> {
                if (parentObservation != null) {
                    this.pendingObservation = parentObservation;
                    this.observeBoltOnly = true;
                } else {
                    this.pendingObservation = this.observationProvider.resultConsume(this.resultType);
                    this.observeBoltOnly = false;
                }
                this.apiCallInProgress = true;
                this.summaryFuture = new CompletableFuture();
                yield this.summaryFuture;
            }
            case 2 -> {
                String message = "Invalid API call.";
                yield CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
            case 3 -> this.stageExposingError(METADATA_EXTRACTOR.extractSummary(this.query, this.boltConnection, this.runSummary.resultAvailableAfter(), Collections.emptyMap(), this.legacyNotifications, null));
            case 4 -> CompletableFuture.completedStage(this.summary);
        };
        CompletableFuture<ResultSummary> future = new CompletableFuture<ResultSummary>();
        summaryFt.whenComplete((summary, throwable) -> {
            if ((throwable = Futures.completionExceptionCause(throwable)) != null) {
                this.consumedFuture.completeExceptionally((Throwable)throwable);
                future.completeExceptionally((Throwable)throwable);
            } else {
                this.consumedFuture.complete(null);
                future.complete((ResultSummary)summary);
            }
        });
        return future;
    }

    @Override
    public synchronized CompletionStage<Record> nextAsync() {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        Record record = this.records.poll();
        if (record == null) {
            return switch (this.state.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    Observation nextObservation = this.observationProvider.resultNext(this.resultType).start();
                    this.apiCallInProgress = true;
                    CompletableFuture<Record> result = this.recordFuture = new CompletableFuture();
                    this.state = State.STREAMING;
                    this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                    this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)this.fetchSize), nextObservation).whenComplete((ignored, throwable) -> {
                        Throwable error = Futures.completionExceptionCause(throwable);
                        if (error != null) {
                            CompletableFuture<Record> recordFuture;
                            ResultCursorImpl resultCursorImpl = this;
                            synchronized (resultCursorImpl) {
                                this.state = State.FAILED;
                                this.errorExposed = true;
                                recordFuture = this.recordFuture;
                                this.recordFuture = null;
                                this.apiCallInProgress = false;
                            }
                            recordFuture.completeExceptionally(error);
                        }
                    });
                    yield ObservationUtil.observeAsyncStarted(nextObservation, () -> result);
                }
                case 1 -> {
                    this.pendingObservation = this.observationProvider.resultNext(this.resultType);
                    this.observeBoltOnly = false;
                    this.apiCallInProgress = true;
                    this.recordFuture = new CompletableFuture();
                    yield this.recordFuture;
                }
                case 2 -> {
                    String message = "Invalid API call.";
                    yield CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
                }
                case 3 -> this.stageExposingError(null);
                case 4 -> CompletableFuture.completedStage(null);
            };
        }
        return CompletableFuture.completedFuture(record);
    }

    @Override
    public synchronized CompletionStage<Record> peekAsync() {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        Record record = this.records.peek();
        if (record == null) {
            return switch (this.state.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    Observation peekObservation = this.observationProvider.resultPeek(this.resultType).start();
                    this.apiCallInProgress = true;
                    CompletableFuture<Record> future = this.peekFuture = new CompletableFuture();
                    this.state = State.STREAMING;
                    this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                    this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)this.fetchSize), peekObservation).whenComplete((ignored, throwable) -> {
                        Throwable error = Futures.completionExceptionCause(throwable);
                        if (error != null) {
                            ResultCursorImpl resultCursorImpl = this;
                            synchronized (resultCursorImpl) {
                                this.state = State.FAILED;
                                this.errorExposed = true;
                                this.recordFuture = this.peekFuture;
                                this.peekFuture = null;
                                this.apiCallInProgress = false;
                            }
                            this.recordFuture.completeExceptionally(error);
                        }
                    });
                    yield ObservationUtil.observeAsyncStarted(peekObservation, () -> future);
                }
                case 1 -> {
                    this.pendingObservation = this.observationProvider.resultPeek(this.resultType);
                    this.observeBoltOnly = false;
                    this.apiCallInProgress = true;
                    this.peekFuture = new CompletableFuture();
                    yield this.peekFuture;
                }
                case 2 -> {
                    String message = "Invalid API call.";
                    yield CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
                }
                case 3 -> this.stageExposingError(null);
                case 4 -> CompletableFuture.completedStage(null);
            };
        }
        return CompletableFuture.completedFuture(record);
    }

    @Override
    public synchronized CompletionStage<Record> singleAsync() {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        if (this.records.size() > 1) {
            this.records.clear();
            return CompletableFuture.failedStage(new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record."));
        }
        return switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (this.records.isEmpty()) {
                    Observation singleObservation = this.observationProvider.resultSingle(this.resultType).start();
                    this.apiCallInProgress = true;
                    this.recordFuture = new CompletableFuture();
                    this.secondRecordFuture = new CompletableFuture();
                    CompletionStage singleFuture = this.recordFuture.thenCompose(firstRecord -> {
                        if (firstRecord == null) {
                            throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
                        }
                        return this.secondRecordFuture.thenApply(secondRecord -> {
                            if (secondRecord.booleanValue()) {
                                throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record.");
                            }
                            return firstRecord;
                        });
                    });
                    this.state = State.STREAMING;
                    this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                    this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)this.fetchSize), singleObservation).whenComplete((ignored, throwable) -> {
                        Throwable error = Futures.completionExceptionCause(throwable);
                        if (error != null) {
                            CompletableFuture<Boolean> secondRecordFuture;
                            CompletableFuture<Record> recordFuture;
                            ResultCursorImpl resultCursorImpl = this;
                            synchronized (resultCursorImpl) {
                                this.state = State.FAILED;
                                this.errorExposed = true;
                                recordFuture = this.recordFuture;
                                this.recordFuture = null;
                                secondRecordFuture = this.secondRecordFuture;
                                this.secondRecordFuture = null;
                                this.apiCallInProgress = false;
                            }
                            recordFuture.completeExceptionally(error);
                            secondRecordFuture.completeExceptionally(error);
                        }
                    });
                    yield ObservationUtil.observeAsyncStarted(singleObservation, () -> ResultCursorImpl.lambda$singleAsync$10((CompletableFuture)singleFuture));
                }
                yield CompletableFuture.failedStage(new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record."));
            }
            case 1 -> {
                this.pendingObservation = this.observationProvider.resultSingle(this.resultType);
                this.observeBoltOnly = false;
                this.apiCallInProgress = true;
                if (this.records.isEmpty()) {
                    this.recordFuture = new CompletableFuture();
                    this.secondRecordFuture = new CompletableFuture();
                    yield this.recordFuture.thenCompose(firstRecord -> {
                        if (firstRecord == null) {
                            throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
                        }
                        return this.secondRecordFuture.thenApply(secondRecord -> {
                            if (secondRecord.booleanValue()) {
                                throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record.");
                            }
                            return firstRecord;
                        });
                    });
                }
                Record firstRecord = this.records.poll();
                this.secondRecordFuture = new CompletableFuture();
                yield this.secondRecordFuture.thenApply(secondRecord -> {
                    if (secondRecord.booleanValue()) {
                        throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record.");
                    }
                    return firstRecord;
                });
            }
            case 2 -> {
                String message = "Invalid API call.";
                yield CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
            case 3 -> this.stageExposingError(null).thenApply(ignored -> {
                throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
            });
            case 4 -> this.records.size() == 1 ? CompletableFuture.completedFuture(this.records.poll()) : CompletableFuture.failedStage(new NoSuchRecordException("Cannot retrieve a single record, because this result is empty."));
        };
    }

    @Override
    public synchronized CompletionStage<ResultSummary> forEachAsync(Consumer<Record> action) {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        CompletableFuture summaryFuture = new CompletableFuture();
        return switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1, 2 -> {
                this.summaryFuture = summaryFuture;
                yield this.listAsync().thenCompose(list -> {
                    list.forEach(action);
                    return summaryFuture;
                });
            }
            case 3 -> this.listAsync().thenApply(ignored -> null);
            case 4 -> this.listAsync().thenApply(list -> {
                list.forEach(action);
                return this.summary;
            });
        };
    }

    @Override
    public synchronized CompletionStage<List<Record>> listAsync() {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        return switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                Observation listObservation = this.observationProvider.resultList(this.resultType).start();
                this.apiCallInProgress = true;
                CompletableFuture<List<Record>> future = this.recordsFuture = new CompletableFuture();
                this.state = State.STREAMING;
                this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)-1L), listObservation).whenComplete((ignored, throwable) -> {
                    Throwable error = Futures.completionExceptionCause(throwable);
                    if (error != null) {
                        CompletableFuture<List<Record>> recordsFuture;
                        ResultCursorImpl resultCursorImpl = this;
                        synchronized (resultCursorImpl) {
                            this.state = State.FAILED;
                            this.errorExposed = true;
                            recordsFuture = this.recordsFuture;
                            this.recordsFuture = null;
                            this.apiCallInProgress = false;
                        }
                        recordsFuture.completeExceptionally(error);
                    }
                });
                yield ObservationUtil.observeAsyncStarted(listObservation, () -> future);
            }
            case 1 -> {
                this.pendingObservation = this.observationProvider.resultList(this.resultType);
                this.observeBoltOnly = false;
                this.apiCallInProgress = true;
                this.recordsFuture = new CompletableFuture();
                yield this.recordsFuture;
            }
            case 2 -> {
                String message = "Invalid API call.";
                yield CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
            case 3 -> this.stageExposingError(null).thenApply(ignored -> Collections.emptyList());
            case 4 -> {
                List records = this.records.stream().toList();
                this.records.clear();
                yield CompletableFuture.completedStage(records);
            }
        };
    }

    @Override
    public <T> CompletionStage<List<T>> listAsync(Function<Record, T> mapFunction) {
        return this.listAsync().thenApply(list -> list.stream().map(mapFunction).toList());
    }

    @Override
    public CompletionStage<Boolean> isOpenAsync() {
        if (this.apiCallInProgress) {
            String message = "API calls to result cursor must be sequential.";
            return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
        }
        return switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1, 2 -> CompletableFuture.completedStage(true);
            case 3, 4 -> CompletableFuture.completedStage(false);
        };
    }

    @Override
    public void onTelemetrySummary(TelemetrySummary summary) {
        if (this.apiTelemetryWork != null) {
            this.apiTelemetryWork.acknowledge();
        }
    }

    @Override
    public void onBeginSummary(BeginSummary summary) {
        if (this.beginFuture != null) {
            summary.databaseName().ifPresent(this.databaseNameConsumer);
            this.beginFuture.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRunSummary(RunSummary summary) {
        ResultCursorImpl resultCursorImpl = this;
        synchronized (resultCursorImpl) {
            this.runSummary = summary;
        }
        summary.databaseName().ifPresent(this.databaseNameConsumer);
        this.resultCursorFuture.complete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecord(List<Value> fields) {
        CompletableFuture<Record> peekFuture;
        InternalRecord record = new InternalRecord(this.runSummary.keys(), fields);
        CompletableFuture<Record> recordFuture = null;
        CompletableFuture<Boolean> secondRecordFuture = null;
        ResultCursorImpl resultCursorImpl = this;
        synchronized (resultCursorImpl) {
            this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.HAD_RECORD);
            peekFuture = this.peekFuture;
            this.peekFuture = null;
            if (peekFuture != null) {
                this.clearPendingObservation();
                this.apiCallInProgress = false;
                this.records.add(record);
            } else {
                recordFuture = this.recordFuture;
                this.recordFuture = null;
                secondRecordFuture = this.secondRecordFuture;
                if (recordFuture == null) {
                    if (secondRecordFuture != null) {
                        this.clearPendingObservation();
                        this.apiCallInProgress = false;
                        this.secondRecordFuture = null;
                    }
                    this.records.add(record);
                } else {
                    this.clearPendingObservation();
                    if (secondRecordFuture == null) {
                        this.apiCallInProgress = false;
                    }
                }
            }
        }
        if (peekFuture != null) {
            peekFuture.complete(record);
        } else if (recordFuture != null) {
            recordFuture.complete(record);
        } else if (secondRecordFuture != null) {
            secondRecordFuture.complete(true);
        }
    }

    @Override
    public synchronized void onError(Throwable throwable) {
        throwable = Futures.completionExceptionCause(throwable);
        if (this.error == null) {
            this.error = throwable;
        } else {
            if (throwable == IGNORED_ERROR) {
                return;
            }
            if (this.error == IGNORED_ERROR || this.error instanceof Neo4jException && !(throwable instanceof Neo4jException)) {
                this.error = throwable;
            }
        }
    }

    @Override
    public void onIgnored() {
        this.onError(IGNORED_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDiscardSummary(DiscardSummary summary) {
        ResultCursorImpl resultCursorImpl = this;
        synchronized (resultCursorImpl) {
            CompletableFuture<Record> peekFuture;
            CompletableFuture<Record> recordFuture = null;
            CompletableFuture<Boolean> secondRecordFuture = null;
            Runnable recordsFutureRunnable = null;
            CompletableFuture<ResultSummary> summaryFuture = null;
            Throwable summaryError = null;
            ResultCursorImpl resultCursorImpl2 = this;
            synchronized (resultCursorImpl2) {
                try {
                    this.summary = METADATA_EXTRACTOR.extractSummary(this.query, this.boltConnection, -1L, summary.metadata(), this.legacyNotifications, this.generateGqlStatusObject(this.runSummary.keys()));
                    this.state = State.SUCCEEDED;
                }
                catch (Throwable throwable2) {
                    summaryError = throwable2;
                }
                peekFuture = this.peekFuture;
                this.peekFuture = null;
                if (peekFuture != null) {
                    this.apiCallInProgress = false;
                } else {
                    recordFuture = this.recordFuture;
                    this.recordFuture = null;
                    if (recordFuture != null) {
                        this.apiCallInProgress = false;
                    } else {
                        secondRecordFuture = this.secondRecordFuture;
                        this.secondRecordFuture = null;
                        if (secondRecordFuture != null) {
                            this.apiCallInProgress = false;
                        } else if (this.recordsFuture != null) {
                            this.apiCallInProgress = false;
                            CompletableFuture<List<Record>> recordsFuture = this.recordsFuture;
                            this.recordsFuture = null;
                            List records = this.records.stream().toList();
                            this.records.clear();
                            recordsFutureRunnable = () -> recordsFuture.complete(records);
                        } else if (this.summaryFuture != null) {
                            this.apiCallInProgress = false;
                            summaryFuture = this.summaryFuture;
                            this.summaryFuture = null;
                        }
                    }
                }
            }
            if (summaryError == null) {
                if (this.closeOnSummary) {
                    CompletableFuture<Record> recordFutureSnapshot = recordFuture;
                    CompletableFuture<Boolean> secondRecordFutureSnapshot = secondRecordFuture;
                    Runnable recordsFutureRunnableSnapshot = recordsFutureRunnable;
                    CompletableFuture<ResultSummary> summaryFutureSnapshot = summaryFuture;
                    this.boltConnection.close().whenComplete((ignored, throwable) -> {
                        if (peekFuture != null) {
                            peekFuture.complete(null);
                        }
                        if (recordFutureSnapshot != null) {
                            recordFutureSnapshot.complete(null);
                        } else if (secondRecordFutureSnapshot != null) {
                            secondRecordFutureSnapshot.complete(false);
                        } else if (recordsFutureRunnableSnapshot != null) {
                            recordsFutureRunnableSnapshot.run();
                        } else if (summaryFutureSnapshot != null) {
                            summaryFutureSnapshot.complete(this.summary);
                        }
                    });
                } else {
                    if (peekFuture != null) {
                        peekFuture.complete(null);
                    }
                    if (recordFuture != null) {
                        recordFuture.complete(null);
                    } else if (secondRecordFuture != null) {
                        secondRecordFuture.complete(false);
                    } else if (recordsFutureRunnable != null) {
                        recordsFutureRunnable.run();
                    } else if (summaryFuture != null) {
                        summaryFuture.complete(this.summary);
                    }
                }
            } else {
                this.onError(summaryError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPullSummary(PullSummary summary) {
        if (summary.hasMore()) {
            CompletableFuture<Boolean> secondRecordFuture = null;
            ResultCursorImpl resultCursorImpl = this;
            synchronized (resultCursorImpl) {
                if (this.peekFuture != null) {
                    Observation observation = this.getAndClearPendingObservation(this.peekFuture);
                    this.state = State.STREAMING;
                    this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                    this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)this.fetchSize), observation).whenComplete((ignored, throwable) -> {
                        Throwable error = Futures.completionExceptionCause(throwable);
                        if (error != null) {
                            CompletableFuture<Record> peekFuture;
                            ResultCursorImpl resultCursorImpl = this;
                            synchronized (resultCursorImpl) {
                                this.state = State.FAILED;
                                this.errorExposed = true;
                                peekFuture = this.peekFuture;
                                this.peekFuture = null;
                                this.apiCallInProgress = false;
                            }
                            peekFuture.completeExceptionally(error);
                        }
                    });
                } else if (this.recordFuture != null) {
                    Observation observation = this.getAndClearPendingObservation(this.recordFuture);
                    this.state = State.STREAMING;
                    this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                    this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)this.fetchSize), observation).whenComplete((ignored, throwable) -> {
                        Throwable error = Futures.completionExceptionCause(throwable);
                        if (error != null) {
                            CompletableFuture<Record> recordFuture;
                            ResultCursorImpl resultCursorImpl = this;
                            synchronized (resultCursorImpl) {
                                this.state = State.FAILED;
                                this.errorExposed = true;
                                recordFuture = this.recordFuture;
                                this.recordFuture = null;
                                this.apiCallInProgress = false;
                            }
                            recordFuture.completeExceptionally(error);
                        }
                    });
                } else {
                    secondRecordFuture = this.secondRecordFuture;
                    this.secondRecordFuture = null;
                    if (secondRecordFuture != null) {
                        this.apiCallInProgress = false;
                        this.state = State.READY;
                    } else if (this.recordsFuture != null) {
                        Observation observation = this.getAndClearPendingObservation(this.recordsFuture);
                        this.state = State.STREAMING;
                        this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                        this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)-1L), observation).whenComplete((ignored, throwable) -> {
                            Throwable error = Futures.completionExceptionCause(throwable);
                            if (error != null) {
                                CompletableFuture<List<Record>> recordsFuture;
                                ResultCursorImpl resultCursorImpl = this;
                                synchronized (resultCursorImpl) {
                                    this.state = State.FAILED;
                                    this.errorExposed = true;
                                    recordsFuture = this.recordsFuture;
                                    this.recordsFuture = null;
                                    this.apiCallInProgress = false;
                                }
                                recordsFuture.completeExceptionally(error);
                            }
                        });
                    } else if (this.summaryFuture != null) {
                        Observation observation = this.getAndClearPendingObservation(this.summaryFuture);
                        this.state = State.DISCARDING;
                        this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.discard((long)this.runSummary.queryId(), (long)-1L), observation).whenComplete((ignored, throwable) -> {
                            Throwable error = Futures.completionExceptionCause(throwable);
                            if (error != null) {
                                CompletableFuture<ResultSummary> summaryFuture;
                                ResultCursorImpl resultCursorImpl = this;
                                synchronized (resultCursorImpl) {
                                    this.state = State.FAILED;
                                    this.errorExposed = true;
                                    summaryFuture = this.summaryFuture;
                                    this.summaryFuture = null;
                                    this.apiCallInProgress = false;
                                }
                                summaryFuture.completeExceptionally(error);
                            }
                        });
                    } else {
                        this.state = State.READY;
                    }
                }
            }
            if (secondRecordFuture != null) {
                secondRecordFuture.complete(true);
            }
        } else {
            CompletableFuture<Record> peekFuture;
            CompletableFuture<Record> recordFuture = null;
            CompletableFuture<Boolean> secondRecordFuture = null;
            Runnable recordsFutureRunnable = null;
            CompletableFuture<ResultSummary> summaryFuture = null;
            DatabaseBookmark databaseBookmark = null;
            Throwable error = null;
            ResultCursorImpl resultCursorImpl = this;
            synchronized (resultCursorImpl) {
                String bookmarkStr;
                this.state = State.SUCCEEDED;
                this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                try {
                    this.summary = METADATA_EXTRACTOR.extractSummary(this.query, this.boltConnection, this.runSummary.resultAvailableAfter(), summary.metadata(), this.legacyNotifications, this.generateGqlStatusObject(this.runSummary.keys()));
                }
                catch (Throwable throwable2) {
                    error = throwable2;
                    this.error = throwable2;
                    this.state = State.FAILED;
                }
                Map<String, Value> metadata = summary.metadata();
                Value bookmarkValue = metadata.get("bookmark");
                if (bookmarkValue != null && !bookmarkValue.isNull() && bookmarkValue.hasType(InternalTypeSystem.TYPE_SYSTEM.STRING()) && !(bookmarkStr = bookmarkValue.asString()).isEmpty()) {
                    databaseBookmark = new DatabaseBookmark(null, Bookmark.from(bookmarkStr));
                }
                peekFuture = this.peekFuture;
                this.peekFuture = null;
                if (peekFuture != null) {
                    this.apiCallInProgress = false;
                    error = this.error;
                    this.errorExposed = true;
                } else {
                    recordFuture = this.recordFuture;
                    this.recordFuture = null;
                    if (recordFuture != null) {
                        this.apiCallInProgress = false;
                        error = this.error;
                        this.errorExposed = true;
                    } else {
                        secondRecordFuture = this.secondRecordFuture;
                        this.secondRecordFuture = null;
                        if (secondRecordFuture != null) {
                            this.apiCallInProgress = false;
                            error = this.error;
                            this.errorExposed = true;
                        } else if (this.recordsFuture != null) {
                            if (this.summaryFuture == null) {
                                this.apiCallInProgress = false;
                                if (this.error == null) {
                                    recordsFuture = this.recordsFuture;
                                    this.recordsFuture = null;
                                    records = this.records.stream().toList();
                                    if (!this.keepRecords) {
                                        this.records.clear();
                                    }
                                    this.keepRecords = false;
                                    recordsFutureRunnable = () -> recordsFuture.complete(records);
                                } else {
                                    recordsFutureRunnable = () -> this.recordsFuture.completeExceptionally(this.error);
                                    this.errorExposed = true;
                                }
                            } else {
                                this.apiCallInProgress = false;
                                summaryFuture = this.summaryFuture;
                                this.summaryFuture = null;
                                if (this.error == null) {
                                    recordsFuture = this.recordsFuture;
                                    this.recordsFuture = null;
                                    records = this.records.stream().toList();
                                    this.records.clear();
                                    recordsFutureRunnable = () -> recordsFuture.complete(records);
                                } else {
                                    error = this.error;
                                    this.errorExposed = true;
                                }
                            }
                        } else if (this.summaryFuture != null) {
                            this.apiCallInProgress = false;
                            summaryFuture = this.summaryFuture;
                            this.summaryFuture = null;
                            error = this.error;
                            this.errorExposed = true;
                        }
                    }
                }
                if (databaseBookmark != null) {
                    this.bookmarkConsumer.accept(databaseBookmark);
                }
            }
            if (this.closeOnSummary) {
                Throwable errorSnapshot = error;
                CompletableFuture<Record> recordFutureSnapshot = recordFuture;
                CompletableFuture<Boolean> secondRecordFutureSnapshot = secondRecordFuture;
                Runnable recordsFutureRunnableSnapshot = recordsFutureRunnable;
                CompletableFuture<ResultSummary> summaryFutureSnapshot = summaryFuture;
                this.boltConnection.close().whenComplete((ignored, closeThrowable) -> {
                    if (peekFuture != null) {
                        if (errorSnapshot != null) {
                            peekFuture.completeExceptionally(errorSnapshot);
                        }
                        peekFuture.complete(null);
                    }
                    if (recordFutureSnapshot != null) {
                        if (errorSnapshot != null) {
                            recordFutureSnapshot.completeExceptionally(errorSnapshot);
                        }
                        recordFutureSnapshot.complete(null);
                    } else if (secondRecordFutureSnapshot != null) {
                        if (errorSnapshot != null) {
                            secondRecordFutureSnapshot.completeExceptionally(errorSnapshot);
                        }
                        secondRecordFutureSnapshot.complete(false);
                    } else if (recordsFutureRunnableSnapshot != null) {
                        recordsFutureRunnableSnapshot.run();
                        if (summaryFutureSnapshot != null) {
                            summaryFutureSnapshot.complete(this.summary);
                        }
                    } else if (summaryFutureSnapshot != null) {
                        if (errorSnapshot != null) {
                            summaryFutureSnapshot.completeExceptionally(errorSnapshot);
                        }
                        summaryFutureSnapshot.complete(this.summary);
                    }
                });
            } else {
                if (peekFuture != null) {
                    if (error != null) {
                        peekFuture.completeExceptionally(error);
                    }
                    peekFuture.complete(null);
                }
                if (recordFuture != null) {
                    if (error != null) {
                        recordFuture.completeExceptionally(error);
                    }
                    recordFuture.complete(null);
                } else if (secondRecordFuture != null) {
                    if (error != null) {
                        secondRecordFuture.completeExceptionally(error);
                    }
                    secondRecordFuture.complete(false);
                } else if (recordsFutureRunnable != null) {
                    recordsFutureRunnable.run();
                    if (summaryFuture != null) {
                        summaryFuture.complete(this.summary);
                    }
                } else if (summaryFuture != null) {
                    if (error != null) {
                        summaryFuture.completeExceptionally(error);
                    }
                    summaryFuture.complete(this.summary);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        Throwable throwable;
        ResultCursorImpl resultCursorImpl = this;
        synchronized (resultCursorImpl) {
            throwable = this.error;
        }
        if (throwable != null) {
            Runnable finisher;
            if (this.beginFuture != null) {
                if (!this.beginFuture.isDone()) {
                    if (this.closeOnSummary) {
                        this.boltConnection.close().whenComplete((ignored, closeThrowable) -> {
                            if (closeThrowable != null && throwable != closeThrowable) {
                                throwable.addSuppressed((Throwable)closeThrowable);
                            }
                            this.beginFuture.completeExceptionally(throwable);
                        });
                    } else {
                        this.beginFuture.completeExceptionally(throwable);
                    }
                    return;
                }
                if (this.beginFuture.isCompletedExceptionally()) {
                    return;
                }
            }
            CompletableFuture<Record> recordFuture = null;
            CompletableFuture<Boolean> secondRecordFuture = null;
            CompletableFuture<List<Record>> recordsFuture = null;
            CompletableFuture<ResultSummary> summaryFuture = null;
            ResultCursorImpl resultCursorImpl2 = this;
            synchronized (resultCursorImpl2) {
                this.state = State.FAILED;
                this.error = throwable;
                if (!this.resultCursorFuture.isDone()) {
                    finisher = this.closeOnSummary ? () -> this.boltConnection.close().whenComplete((ignored, closeThrowable) -> {
                        if (closeThrowable != null && throwable != closeThrowable) {
                            throwable.addSuppressed((Throwable)closeThrowable);
                        }
                        this.resultCursorFuture.completeExceptionally(throwable);
                    }) : () -> this.resultCursorFuture.completeExceptionally(throwable);
                } else if (this.resultCursorFuture.isCompletedExceptionally()) {
                    finisher = () -> {};
                } else {
                    CompletableFuture<Record> peekFuture = this.peekFuture;
                    this.peekFuture = null;
                    if (peekFuture != null) {
                        this.errorExposed = true;
                        this.apiCallInProgress = false;
                    } else {
                        recordFuture = this.recordFuture;
                        this.recordFuture = null;
                        if (recordFuture != null) {
                            secondRecordFuture = this.secondRecordFuture;
                            this.secondRecordFuture = null;
                            this.errorExposed = true;
                            this.apiCallInProgress = false;
                        } else {
                            secondRecordFuture = this.secondRecordFuture;
                            this.secondRecordFuture = null;
                            if (secondRecordFuture != null) {
                                this.errorExposed = true;
                                this.apiCallInProgress = false;
                            } else {
                                recordsFuture = this.recordsFuture;
                                this.recordsFuture = null;
                                if (recordsFuture != null) {
                                    this.errorExposed = true;
                                    this.apiCallInProgress = false;
                                } else {
                                    summaryFuture = this.summaryFuture;
                                    this.summaryFuture = null;
                                    if (summaryFuture != null) {
                                        this.errorExposed = true;
                                        this.apiCallInProgress = false;
                                    }
                                }
                            }
                        }
                    }
                    CompletableFuture<Record> recordFutureSnapshot = recordFuture;
                    CompletableFuture<Boolean> secondRecordFutureSnapshot = secondRecordFuture;
                    CompletableFuture<List<Record>> recordsFutureSnapshot = recordsFuture;
                    CompletableFuture<ResultSummary> summaryFutureSnapshot = summaryFuture;
                    finisher = this.closeOnSummary ? () -> this.boltConnection.close().whenComplete((ignored, closeThrowable) -> {
                        if (closeThrowable != null && throwable != closeThrowable) {
                            throwable.addSuppressed((Throwable)closeThrowable);
                        }
                        if (peekFuture != null) {
                            peekFuture.completeExceptionally(throwable);
                        }
                        if (recordFutureSnapshot != null) {
                            recordFutureSnapshot.completeExceptionally(throwable);
                        }
                        if (secondRecordFutureSnapshot != null) {
                            secondRecordFutureSnapshot.completeExceptionally(throwable);
                        }
                        if (recordsFutureSnapshot != null) {
                            recordsFutureSnapshot.completeExceptionally(throwable);
                        }
                        if (summaryFutureSnapshot != null) {
                            summaryFutureSnapshot.completeExceptionally(throwable);
                        }
                    }) : () -> {
                        if (peekFuture != null) {
                            peekFuture.completeExceptionally(throwable);
                        }
                        if (recordFutureSnapshot != null) {
                            recordFutureSnapshot.completeExceptionally(throwable);
                        }
                        if (secondRecordFutureSnapshot != null) {
                            secondRecordFutureSnapshot.completeExceptionally(throwable);
                        }
                        if (recordsFutureSnapshot != null) {
                            recordsFutureSnapshot.completeExceptionally(throwable);
                        }
                        if (summaryFutureSnapshot != null) {
                            summaryFutureSnapshot.completeExceptionally(throwable);
                        }
                    };
                }
            }
            finisher.run();
        }
    }

    @Override
    public synchronized CompletionStage<Throwable> discardAllFailureAsync(Observation parentObservation) {
        return this.consumeAsync(parentObservation).handle((summary, error) -> error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Throwable> pullAllFailureAsync(Observation parentObservation) {
        ResultCursorImpl resultCursorImpl = this;
        synchronized (resultCursorImpl) {
            if (this.apiCallInProgress) {
                String message = "API calls to result cursor must be sequential.";
                return CompletableFuture.failedStage(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
            return switch (this.state.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    this.apiCallInProgress = true;
                    this.summaryFuture = new CompletableFuture();
                    this.state = State.STREAMING;
                    this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
                    this.boltConnection.writeAndFlush((DriverResponseHandler)this, (Message)Messages.pull((long)this.runSummary.queryId(), (long)-1L), parentObservation).whenComplete((ignored, throwable) -> {
                        Throwable error = Futures.completionExceptionCause(throwable);
                        if (error != null) {
                            CompletableFuture<ResultSummary> summaryFuture;
                            ResultCursorImpl resultCursorImpl = this;
                            synchronized (resultCursorImpl) {
                                this.state = State.FAILED;
                                this.errorExposed = true;
                                summaryFuture = this.summaryFuture;
                                this.summaryFuture = null;
                                this.apiCallInProgress = false;
                            }
                            summaryFuture.completeExceptionally(error);
                        }
                    });
                    yield this.summaryFuture.handle((ignored, throwable) -> throwable);
                }
                case 1 -> {
                    this.apiCallInProgress = true;
                    this.recordsFuture = new CompletableFuture();
                    this.keepRecords = true;
                    yield this.recordsFuture.handle((ignored, throwable) -> throwable);
                }
                case 2 -> {
                    this.apiCallInProgress = true;
                    this.summaryFuture = new CompletableFuture();
                    yield this.summaryFuture.handle((ignored, throwable) -> throwable);
                }
                case 3 -> this.stageExposingError(null).handle((ignored, throwable) -> throwable);
                case 4 -> CompletableFuture.completedStage(null);
            };
        }
    }

    @Override
    public CompletionStage<Void> consumed() {
        return this.consumedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletionStage<T> stageExposingError(T value) {
        ResultCursorImpl resultCursorImpl = this;
        synchronized (resultCursorImpl) {
            if (this.error != null && !this.errorExposed) {
                this.errorExposed = true;
                return CompletableFuture.failedStage(this.error);
            }
        }
        return CompletableFuture.completedStage(value);
    }

    private synchronized void clearPendingObservation() {
        this.pendingObservation = null;
    }

    private synchronized Observation getAndClearPendingObservation(CompletionStage<?> observable) {
        if (this.pendingObservation == null) {
            return NoopObservation.getInstance();
        }
        Observation observation = this.pendingObservation;
        this.pendingObservation = null;
        if (!this.observeBoltOnly) {
            observation.start();
            observable.whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    observation.error(Futures.completionExceptionCause(throwable));
                }
                observation.stop();
            });
        }
        this.observeBoltOnly = false;
        return observation;
    }

    private static /* synthetic */ CompletionStage lambda$singleAsync$10(CompletableFuture singleFuture) {
        return singleFuture;
    }

    private static enum State {
        READY,
        STREAMING,
        DISCARDING,
        FAILED,
        SUCCEEDED;

    }
}

