/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.internal.util.LockUtil;

public final class Neo4jBookmarkManager
implements BookmarkManager {
    private static final long serialVersionUID = -737795053416084953L;
    transient ReadWriteLock rwLock = new ReentrantReadWriteLock();
    final Set<Bookmark> bookmarks;
    final Consumer<Set<Bookmark>> updateListener;
    final Supplier<Set<Bookmark>> bookmarksSupplier;

    public Neo4jBookmarkManager(Set<Bookmark> initialBookmarks, Consumer<Set<Bookmark>> updateListener, Supplier<Set<Bookmark>> bookmarksSupplier) {
        Objects.requireNonNull(initialBookmarks, "initialBookmarks must not be null");
        this.bookmarks = new HashSet<Bookmark>(initialBookmarks);
        this.updateListener = updateListener;
        this.bookmarksSupplier = bookmarksSupplier;
    }

    @Override
    public void updateBookmarks(Set<Bookmark> previousBookmarks, Set<Bookmark> newBookmarks) {
        Set immutableBookmarks = LockUtil.executeWithLock(this.rwLock.writeLock(), () -> {
            this.bookmarks.removeAll(previousBookmarks);
            this.bookmarks.addAll(newBookmarks);
            return Collections.unmodifiableSet(new HashSet<Bookmark>(this.bookmarks));
        });
        if (this.updateListener != null) {
            this.updateListener.accept(immutableBookmarks);
        }
    }

    @Override
    public Set<Bookmark> getBookmarks() {
        HashSet bookmarks = LockUtil.executeWithLock(this.rwLock.readLock(), () -> new HashSet<Bookmark>(this.bookmarks));
        if (this.bookmarksSupplier != null) {
            bookmarks.addAll((Collection)this.bookmarksSupplier.get());
        }
        return Collections.unmodifiableSet(bookmarks);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rwLock = new ReentrantReadWriteLock();
    }
}

