/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.exceptions.TokenExpiredException;

public class StaticAuthTokenManager
implements AuthTokenManager {
    private final AtomicBoolean expired = new AtomicBoolean();
    private final AuthToken authToken;

    public StaticAuthTokenManager(AuthToken authToken) {
        Objects.requireNonNull(authToken, "authToken must not be null");
        this.authToken = authToken;
    }

    @Override
    public CompletionStage<AuthToken> getToken() {
        return this.expired.get() ? CompletableFuture.failedFuture(new TokenExpiredException(null, "authToken is expired")) : CompletableFuture.completedFuture(this.authToken);
    }

    @Override
    public void onExpired(AuthToken authToken) {
        if (authToken.equals(this.authToken)) {
            this.expired.set(true);
        }
    }
}

