/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class RxUtils {
    public static <T> Publisher<T> createEmptyPublisher(Supplier<CompletionStage<Void>> supplier) {
        return Mono.create(sink -> ((CompletionStage)supplier.get()).whenComplete((ignore, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                sink.error(error);
            } else {
                sink.success();
            }
        }));
    }

    public static <T> Publisher<T> createSingleItemPublisher(Supplier<CompletionStage<T>> supplier, Supplier<Throwable> nullResultThrowableSupplier, Consumer<T> cancellationHandler) {
        Objects.requireNonNull(supplier, "supplier must not be null");
        Objects.requireNonNull(nullResultThrowableSupplier, "nullResultThrowableSupplier must not be null");
        Objects.requireNonNull(cancellationHandler, "cancellationHandler must not be null");
        return Mono.create(sink -> {
            SinkState state = new SinkState();
            sink.onRequest(arg_0 -> RxUtils.lambda$createSingleItemPublisher$3(state, (Supplier)supplier, sink, (Supplier)nullResultThrowableSupplier, arg_0));
            sink.onCancel(() -> {
                CompletionStage<Object> stage;
                SinkState sinkState = state;
                synchronized (sinkState) {
                    if (state.isCancelled()) {
                        return;
                    }
                    state.setCancelled(true);
                    stage = state.getStage();
                }
                if (stage != null) {
                    stage.whenComplete((value, ignored) -> cancellationHandler.accept(value));
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$createSingleItemPublisher$3(SinkState state, Supplier supplier, MonoSink sink, Supplier nullResultThrowableSupplier, long ignored) {
        CompletionStage stage;
        SinkState sinkState = state;
        synchronized (sinkState) {
            if (state.isCancelled()) {
                return;
            }
            if (state.getStage() != null) {
                return;
            }
            stage = (CompletionStage)supplier.get();
            state.setStage(stage);
        }
        stage.whenComplete((arg_0, arg_1) -> RxUtils.lambda$createSingleItemPublisher$2(sink, (Supplier)nullResultThrowableSupplier, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$createSingleItemPublisher$2(MonoSink sink, Supplier nullResultThrowableSupplier, Object item, Throwable completionError) {
        if (completionError == null) {
            if (item != null) {
                sink.success(item);
            } else {
                sink.error((Throwable)nullResultThrowableSupplier.get());
            }
        } else {
            Throwable error = Optional.ofNullable(Futures.completionExceptionCause(completionError)).orElse(completionError);
            sink.error(error);
        }
    }

    private static class SinkState<T> {
        private CompletionStage<T> stage;
        private boolean cancelled;

        private SinkState() {
        }

        public CompletionStage<T> getStage() {
            return this.stage;
        }

        public void setStage(CompletionStage<T> stage) {
            this.stage = stage;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }
}

