/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.messaging.request.MessageWithMetadata;
import org.neo4j.driver.internal.messaging.request.TransactionMetadataBuilder;

public class BeginMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 17;

    public BeginMessage(Set<Bookmark> bookmarks, TransactionConfig config, DatabaseName databaseName, AccessMode mode, String impersonatedUser, String txType, NotificationConfig notificationConfig) {
        this(bookmarks, config.timeout(), config.metadata(), mode, databaseName, impersonatedUser, txType, notificationConfig);
    }

    public BeginMessage(Set<Bookmark> bookmarks, Duration txTimeout, Map<String, Value> txMetadata, AccessMode mode, DatabaseName databaseName, String impersonatedUser, String txType, NotificationConfig notificationConfig) {
        super(TransactionMetadataBuilder.buildMetadata(txTimeout, txMetadata, databaseName, mode, bookmarks, impersonatedUser, txType, notificationConfig));
    }

    @Override
    public byte signature() {
        return 17;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeginMessage that = (BeginMessage)o;
        return Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.metadata());
    }

    public String toString() {
        return "BEGIN " + this.metadata();
    }
}

