/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;
import java.time.Clock;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DefaultDomainNameResolver;
import org.neo4j.driver.internal.DirectConnectionProvider;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.cluster.IdentityResolver;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.logging.NettyLogging;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.metrics.MicrometerMetricsProvider;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlans;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.net.ServerAddressResolver;

public class DriverFactory {
    public static final String NO_ROUTING_CONTEXT_ERROR_MESSAGE = "Routing parameters are not supported with scheme 'bolt'. Given URI: ";

    public final Driver newInstance(URI uri, AuthToken authToken, Config config) {
        return this.newInstance(uri, authToken, config, null, null, null);
    }

    public final Driver newInstance(URI uri, AuthToken authToken, Config config, SecurityPlan securityPlan, EventLoopGroup eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        boolean ownsEventLoopGroup;
        Bootstrap bootstrap;
        if (eventLoopGroup == null) {
            bootstrap = this.createBootstrap(config.eventLoopThreads());
            ownsEventLoopGroup = true;
        } else {
            bootstrap = this.createBootstrap(eventLoopGroup);
            ownsEventLoopGroup = false;
        }
        if (securityPlan == null) {
            SecuritySettings settings = new SecuritySettings(config.encrypted(), config.trustStrategy());
            securityPlan = SecurityPlans.createSecurityPlan(settings, uri.getScheme());
        }
        authToken = authToken == null ? AuthTokens.none() : authToken;
        BoltServerAddress address = new BoltServerAddress(uri);
        RoutingSettings routingSettings = new RoutingSettings(config.routingTablePurgeDelayMillis(), new RoutingContext(uri));
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLogging(config.logging()));
        EventLoopGroup eventExecutorGroup = bootstrap.config().group();
        RetryLogic retryLogic = this.createRetryLogic(config.maxTransactionRetryTimeMillis(), (EventExecutorGroup)eventExecutorGroup, config.logging());
        MetricsProvider metricsProvider = DriverFactory.getOrCreateMetricsProvider(config, this.createClock());
        ConnectionPool connectionPool = this.createConnectionPool(authToken, securityPlan, bootstrap, metricsProvider, config, ownsEventLoopGroup, routingSettings.routingContext());
        return this.createDriver(uri, securityPlan, address, connectionPool, (EventExecutorGroup)eventExecutorGroup, routingSettings, retryLogic, metricsProvider, rediscoverySupplier, config);
    }

    protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
        Clock clock = this.createClock();
        ConnectionSettings settings = new ConnectionSettings(authToken, config.userAgent(), config.connectionTimeoutMillis());
        ChannelConnector connector = this.createConnector(settings, securityPlan, config, clock, routingContext);
        PoolSettings poolSettings = new PoolSettings(config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis(), config.maxConnectionLifetimeMillis(), config.idleTimeBeforeConnectionTest());
        return new ConnectionPoolImpl(connector, bootstrap, poolSettings, metricsProvider.metricsListener(), config.logging(), clock, ownsEventLoopGroup);
    }

    protected static MetricsProvider getOrCreateMetricsProvider(Config config, Clock clock) {
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        if (metricsAdapter == null) {
            metricsAdapter = config.isMetricsEnabled() ? MetricsAdapter.DEFAULT : MetricsAdapter.DEV_NULL;
        }
        switch (metricsAdapter) {
            case DEV_NULL: {
                return DevNullMetricsProvider.INSTANCE;
            }
            case DEFAULT: {
                return new InternalMetricsProvider(clock, config.logging());
            }
            case MICROMETER: {
                return MicrometerMetricsProvider.forGlobalRegistry();
            }
        }
        throw new IllegalStateException("Unknown or unsupported MetricsAdapter: " + metricsAdapter);
    }

    protected ChannelConnector createConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock, RoutingContext routingContext) {
        return new ChannelConnectorImpl(settings, securityPlan, config.logging(), clock, routingContext, this.getDomainNameResolver());
    }

    private InternalDriver createDriver(URI uri, SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Supplier<Rediscovery> rediscoverySupplier, Config config) {
        try {
            String scheme = uri.getScheme().toLowerCase();
            if (Scheme.isRoutingScheme(scheme)) {
                return this.createRoutingDriver(securityPlan, address, connectionPool, eventExecutorGroup, routingSettings, retryLogic, metricsProvider, rediscoverySupplier, config);
            }
            DriverFactory.assertNoRoutingContext(uri, routingSettings);
            return this.createDirectDriver(securityPlan, address, connectionPool, retryLogic, metricsProvider, config);
        }
        catch (Throwable driverError) {
            DriverFactory.closeConnectionPoolAndSuppressError(connectionPool, driverError);
            throw driverError;
        }
    }

    protected InternalDriver createDirectDriver(SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config) {
        DirectConnectionProvider connectionProvider = new DirectConnectionProvider(address, connectionPool);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        InternalDriver driver = this.createDriver(securityPlan, sessionFactory, metricsProvider, config);
        Logger log = config.logging().getLog(this.getClass());
        log.info("Direct driver instance %s created for server address %s", driver.hashCode(), address);
        return driver;
    }

    protected InternalDriver createRoutingDriver(SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Supplier<Rediscovery> rediscoverySupplier, Config config) {
        LoadBalancer connectionProvider = this.createLoadBalancer(address, connectionPool, eventExecutorGroup, config, routingSettings, rediscoverySupplier);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        InternalDriver driver = this.createDriver(securityPlan, sessionFactory, metricsProvider, config);
        Logger log = config.logging().getLog(this.getClass());
        log.info("Routing driver instance %s created for server address %s", driver.hashCode(), address);
        return driver;
    }

    protected InternalDriver createDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Config config) {
        return new InternalDriver(config.queryTaskBookmarkManager(), securityPlan, sessionFactory, metricsProvider, config.logging());
    }

    protected LoadBalancer createLoadBalancer(BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, Config config, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier) {
        LeastConnectedLoadBalancingStrategy loadBalancingStrategy = new LeastConnectedLoadBalancingStrategy(connectionPool, config.logging());
        ServerAddressResolver resolver = DriverFactory.createResolver(config);
        DomainNameResolver domainNameResolver = Objects.requireNonNull(this.getDomainNameResolver(), "domainNameResolver must not be null");
        Clock clock = this.createClock();
        Logging logging = config.logging();
        if (rediscoverySupplier == null) {
            rediscoverySupplier = () -> this.createRediscovery(address, resolver, routingSettings, clock, logging, domainNameResolver);
        }
        LoadBalancer loadBalancer = new LoadBalancer(connectionPool, rediscoverySupplier.get(), routingSettings, loadBalancingStrategy, eventExecutorGroup, clock, logging);
        this.handleNewLoadBalancer(loadBalancer);
        return loadBalancer;
    }

    protected Rediscovery createRediscovery(BoltServerAddress initialRouter, ServerAddressResolver resolver, RoutingSettings settings, Clock clock, Logging logging, DomainNameResolver domainNameResolver) {
        RoutingProcedureClusterCompositionProvider clusterCompositionProvider = new RoutingProcedureClusterCompositionProvider(clock, settings.routingContext());
        return new RediscoveryImpl(initialRouter, clusterCompositionProvider, resolver, logging, domainNameResolver);
    }

    protected void handleNewLoadBalancer(LoadBalancer loadBalancer) {
    }

    private static ServerAddressResolver createResolver(Config config) {
        ServerAddressResolver configuredResolver = config.resolver();
        return configuredResolver != null ? configuredResolver : IdentityResolver.IDENTITY_RESOLVER;
    }

    protected Clock createClock() {
        return Clock.systemUTC();
    }

    protected SessionFactory createSessionFactory(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        return new SessionFactoryImpl(connectionProvider, retryLogic, config);
    }

    protected RetryLogic createRetryLogic(long maxTransactionRetryTime, EventExecutorGroup eventExecutorGroup, Logging logging) {
        return new ExponentialBackoffRetryLogic(maxTransactionRetryTime, eventExecutorGroup, this.createClock(), logging);
    }

    protected Bootstrap createBootstrap(int size) {
        return BootstrapFactory.newBootstrap(size);
    }

    protected Bootstrap createBootstrap(EventLoopGroup eventLoopGroup) {
        return BootstrapFactory.newBootstrap(eventLoopGroup);
    }

    protected DomainNameResolver getDomainNameResolver() {
        return DefaultDomainNameResolver.getInstance();
    }

    private static void assertNoRoutingContext(URI uri, RoutingSettings routingSettings) {
        RoutingContext routingContext = routingSettings.routingContext();
        if (routingContext.isDefined()) {
            throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + uri + "'");
        }
    }

    private static void closeConnectionPoolAndSuppressError(ConnectionPool connectionPool, Throwable mainError) {
        try {
            Futures.blockingGet(connectionPool.close());
        }
        catch (Throwable closeError) {
            ErrorUtil.addSuppressed(mainError, closeError);
        }
    }
}

