/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.QueryConfig;
import org.neo4j.driver.QueryTask;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.RoutingControl;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.summary.ResultSummary;

public class InternalQueryTask
implements QueryTask {
    private final Driver driver;
    private final Query query;
    private final QueryConfig config;

    public InternalQueryTask(Driver driver, Query query, QueryConfig config) {
        Objects.requireNonNull(driver, "driver must not be null");
        Objects.requireNonNull(query, "query must not be null");
        Objects.requireNonNull(config, "config must not be null");
        this.driver = driver;
        this.query = query;
        this.config = config;
    }

    @Override
    public QueryTask withParameters(Map<String, Object> parameters) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        return new InternalQueryTask(this.driver, this.query.withParameters(parameters), this.config);
    }

    @Override
    public QueryTask withConfig(QueryConfig config) {
        Objects.requireNonNull(config, "config must not be null");
        return new InternalQueryTask(this.driver, this.query, config);
    }

    @Override
    public <A, R, T> T execute(Collector<Record, A, R> recordCollector, QueryTask.ResultFinisher<R, T> resultFinisher) {
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.builder();
        this.config.database().ifPresent(sessionConfigBuilder::withDatabase);
        this.config.impersonatedUser().ifPresent(sessionConfigBuilder::withImpersonatedUser);
        this.config.bookmarkManager(this.driver.queryBookmarkManager()).ifPresent(sessionConfigBuilder::withBookmarkManager);
        Supplier supplier = recordCollector.supplier();
        BiConsumer accumulator = recordCollector.accumulator();
        Function finisher = recordCollector.finisher();
        try (Session session = this.driver.session(sessionConfigBuilder.build());){
            TransactionCallback<Object> txCallback = tx -> {
                Result result = tx.run(this.query);
                Object container = supplier.get();
                while (result.hasNext()) {
                    accumulator.accept(container, result.next());
                }
                Object finishedValue = finisher.apply(container);
                ResultSummary summary = result.consume();
                return resultFinisher.finish(result.keys(), finishedValue, summary);
            };
            Object object = switch (this.config.routing()) {
                default -> throw new IncompatibleClassChangeError();
                case RoutingControl.WRITERS -> session.executeWrite(txCallback);
                case RoutingControl.READERS -> session.executeRead(txCallback);
            };
            return (T)object;
        }
    }

    public Driver driver() {
        return this.driver;
    }

    public String query() {
        return this.query.text();
    }

    public Map<String, Object> parameters() {
        return this.query.parameters().asMap();
    }

    public QueryConfig config() {
        return this.config;
    }
}

