/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value.mapping;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.value.mapping.MapAccessorMapper;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;

class DurationMapper
implements MapAccessorMapper<TemporalAmount> {
    private static final TypeSystem TS = TypeSystem.getDefault();

    DurationMapper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(MapAccessor mapAccessor, Class<?> targetClass) {
        if (!(mapAccessor instanceof Value)) return false;
        Value value = (Value)mapAccessor;
        if (!TS.DURATION().equals(value.type())) return false;
        if (targetClass.isAssignableFrom(Period.class)) return true;
        if (!targetClass.isAssignableFrom(Duration.class)) return false;
        return true;
    }

    @Override
    public TemporalAmount map(MapAccessor mapAccessor, Class<TemporalAmount> targetClass) {
        if (mapAccessor instanceof Value) {
            Value value = (Value)mapAccessor;
            IsoDuration isoDuration = value.asIsoDuration();
            if (targetClass.isAssignableFrom(TemporalAmount.class)) {
                return isoDuration;
            }
            if (targetClass.isAssignableFrom(Period.class)) {
                if (isoDuration.seconds() != 0L || isoDuration.nanoseconds() != 0) {
                    throw new LossyCoercion(value.type().name(), targetClass.getCanonicalName());
                }
                long totalMonths = isoDuration.months();
                long splitYears = totalMonths / 12L;
                long splitMonths = totalMonths % 12L;
                try {
                    return Period.of(Math.toIntExact(splitYears), Math.toIntExact(splitMonths), Math.toIntExact(isoDuration.days())).normalized();
                }
                catch (ArithmeticException e) {
                    throw new LossyCoercion(value.type().name(), targetClass.getCanonicalName());
                }
            }
            if (targetClass.isAssignableFrom(Duration.class)) {
                if (isoDuration.months() != 0L || isoDuration.days() != 0L) {
                    throw new LossyCoercion(value.type().name(), targetClass.getCanonicalName());
                }
                return Duration.ofSeconds(isoDuration.seconds()).plusNanos(isoDuration.nanoseconds());
            }
            throw new Uncoercible(value.type().name(), targetClass.getCanonicalName());
        }
        throw new Uncoercible(mapAccessor.getClass().getCanonicalName(), targetClass.getCanonicalName());
    }
}

