/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Arrays;
import java.util.Optional;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;

public class InternalNotification
implements Notification {
    private final String code;
    private final String title;
    private final String description;
    private final NotificationSeverity severityLevel;
    private final String rawSeverityLevel;
    private final NotificationCategory category;
    private final String rawCategory;
    private final InputPosition position;

    public static Optional<NotificationCategory> valueOf(String value) {
        return Arrays.stream(NotificationClassification.values()).filter(type -> type.toString().equals(value)).findFirst().map(type -> switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationClassification.HINT -> NotificationCategory.HINT;
            case NotificationClassification.UNRECOGNIZED -> NotificationCategory.UNRECOGNIZED;
            case NotificationClassification.UNSUPPORTED -> NotificationCategory.UNSUPPORTED;
            case NotificationClassification.PERFORMANCE -> NotificationCategory.PERFORMANCE;
            case NotificationClassification.DEPRECATION -> NotificationCategory.DEPRECATION;
            case NotificationClassification.SECURITY -> NotificationCategory.SECURITY;
            case NotificationClassification.TOPOLOGY -> NotificationCategory.TOPOLOGY;
            case NotificationClassification.GENERIC -> NotificationCategory.GENERIC;
            case NotificationClassification.SCHEMA -> NotificationCategory.SCHEMA;
        });
    }

    public InternalNotification(String code, String title, String description, NotificationSeverity severityLevel, String rawSeverityLevel, NotificationCategory category, String rawCategory, InputPosition position) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.severityLevel = severityLevel;
        this.rawSeverityLevel = rawSeverityLevel;
        this.category = category;
        this.rawCategory = rawCategory;
        this.position = position;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public InputPosition position() {
        return this.position;
    }

    @Override
    public Optional<NotificationSeverity> severityLevel() {
        return Optional.ofNullable(this.severityLevel);
    }

    @Override
    public Optional<String> rawSeverityLevel() {
        return Optional.ofNullable(this.rawSeverityLevel);
    }

    @Override
    public Optional<NotificationCategory> category() {
        return Optional.ofNullable(this.category);
    }

    @Override
    public Optional<String> rawCategory() {
        return Optional.ofNullable(this.rawCategory);
    }

    public String toString() {
        String info = "code=" + this.code + ", title=" + this.title + ", description=" + this.description + ", severityLevel=" + this.severityLevel + ", rawSeverityLevel=" + this.rawSeverityLevel + ", category=" + this.category + ", rawCategory=" + this.rawCategory;
        return this.position == null ? info : info + ", position={" + this.position + "}";
    }
}

