/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalMapAccessorWithDefaultValue;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Format;
import org.neo4j.driver.internal.util.QueryKeys;
import org.neo4j.driver.internal.value.mapping.MapAccessorMapperProvider;
import org.neo4j.driver.util.Pair;

public class InternalRecord
extends InternalMapAccessorWithDefaultValue
implements Record {
    private final QueryKeys queryKeys;
    private final Value[] values;
    private int hashCode = 0;

    public InternalRecord(List<String> keys, Value[] values) {
        this.queryKeys = new QueryKeys(keys);
        this.values = values;
    }

    public InternalRecord(QueryKeys queryKeys, Value[] values) {
        this.queryKeys = queryKeys;
        this.values = values;
    }

    @Override
    public List<String> keys() {
        return this.queryKeys.keys();
    }

    @Override
    public List<Value> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return this.values().stream().map(mapFunction).collect(Collectors.toList());
    }

    @Override
    public List<Pair<String, Value>> fields() {
        return Extract.fields(this, Values.ofValue());
    }

    @Override
    public int index(String key) {
        int result = this.queryKeys.indexOf(key);
        if (result == -1) {
            throw new NoSuchElementException("Unknown key: " + key);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.queryKeys.contains(key);
    }

    @Override
    public Value get(String key) {
        int fieldIndex = this.queryKeys.indexOf(key);
        if (fieldIndex == -1) {
            return Values.NULL;
        }
        return this.values[fieldIndex];
    }

    @Override
    public Value get(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Map<String, Object> asMap() {
        return Extract.map(this, Values.ofObject());
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapper) {
        return Extract.map(this, mapper);
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(Record.class)) {
            return targetClass.cast(this);
        }
        return (T)MapAccessorMapperProvider.mapper(this, targetClass).map(mapper -> mapper.map(this, targetClass)).orElseThrow(() -> new Uncoercible(this.getClass().getCanonicalName(), targetClass.getCanonicalName()));
    }

    public String toString() {
        return String.format("Record<%s>", Format.formatPairs(this.asMap(Values.ofValue())));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Record) {
            Record otherRecord = (Record)other;
            int size = this.size();
            if (size != otherRecord.size()) {
                return false;
            }
            if (!this.queryKeys.keys().equals(otherRecord.keys())) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Value otherValue;
                Value value = this.get(i);
                if (value.equals(otherValue = otherRecord.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * this.queryKeys.hashCode() + Arrays.hashCode(this.values);
        }
        return this.hashCode;
    }
}

