/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.bolt.connection.values.IsoDuration;
import org.neo4j.bolt.connection.values.Point;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.value.InternalValue;

public class BoltValue
implements org.neo4j.bolt.connection.values.Value {
    private final InternalValue value;
    private final Type type;

    public BoltValue(InternalValue value, Type type) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
    }

    public Value asDriverValue() {
        return this.value;
    }

    public Type type() {
        return this.type;
    }

    public boolean asBoolean() {
        return this.value.asBoolean();
    }

    public byte[] asByteArray() {
        return this.value.asByteArray();
    }

    public String asString() {
        return this.value.asString();
    }

    public long asLong() {
        return this.value.asLong();
    }

    public double asDouble() {
        return this.value.asDouble();
    }

    public LocalDate asLocalDate() {
        return this.value.asLocalDate();
    }

    public OffsetTime asOffsetTime() {
        return this.value.asOffsetTime();
    }

    public LocalTime asLocalTime() {
        return this.value.asLocalTime();
    }

    public LocalDateTime asLocalDateTime() {
        return this.value.asLocalDateTime();
    }

    public ZonedDateTime asZonedDateTime() {
        return this.value.asZonedDateTime();
    }

    public IsoDuration asIsoDuration() {
        return (InternalIsoDuration)this.value.asIsoDuration();
    }

    public Point asPoint() {
        org.neo4j.driver.types.Point point = this.value.asPoint();
        if (point instanceof InternalPoint2D) {
            InternalPoint2D internalPoint2D = (InternalPoint2D)point;
            return internalPoint2D;
        }
        if (point instanceof InternalPoint3D) {
            InternalPoint3D internalPoint3D = (InternalPoint3D)point;
            return internalPoint3D;
        }
        throw new Uncoercible(this.value.type().name(), "Bolt IsoDuration");
    }

    public boolean isNull() {
        return this.value.isNull();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public Iterable<String> keys() {
        return this.value.keys();
    }

    public int size() {
        return this.value.size();
    }

    public org.neo4j.bolt.connection.values.Value get(String key) {
        return ((InternalValue)this.value.get(key)).asBoltValue();
    }

    public Iterable<org.neo4j.bolt.connection.values.Value> values() {
        return () -> new Iterator<org.neo4j.bolt.connection.values.Value>(){
            private final Iterator<Value> iterator;
            {
                this.iterator = BoltValue.this.value.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public org.neo4j.bolt.connection.values.Value next() {
                return ((InternalValue)this.iterator.next()).asBoltValue();
            }
        };
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    public <T> Map<String, T> asMap(Function<org.neo4j.bolt.connection.values.Value, T> mapFunction) {
        return this.value.asMap((Value v) -> mapFunction.apply(((InternalValue)v).asBoltValue()));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltValue boltValue = (BoltValue)o;
        return Objects.equals(this.value, boltValue.value) && this.type == boltValue.type;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public String toString() {
        return this.value.toString();
    }
}

