/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.async.connection;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.AuthorizationStateListener;
import org.neo4j.driver.internal.bolt.basicimpl.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltPatchesListener;

public final class ChannelAttributes {
    private static final AttributeKey<String> CONNECTION_ID = AttributeKey.newInstance((String)"connectionId");
    private static final AttributeKey<BoltProtocolVersion> PROTOCOL_VERSION = AttributeKey.newInstance((String)"protocolVersion");
    private static final AttributeKey<String> SERVER_AGENT = AttributeKey.newInstance((String)"serverAgent");
    private static final AttributeKey<BoltServerAddress> ADDRESS = AttributeKey.newInstance((String)"serverAddress");
    private static final AttributeKey<Long> CREATION_TIMESTAMP = AttributeKey.newInstance((String)"creationTimestamp");
    private static final AttributeKey<Long> LAST_USED_TIMESTAMP = AttributeKey.newInstance((String)"lastUsedTimestamp");
    private static final AttributeKey<InboundMessageDispatcher> MESSAGE_DISPATCHER = AttributeKey.newInstance((String)"messageDispatcher");
    private static final AttributeKey<String> TERMINATION_REASON = AttributeKey.newInstance((String)"terminationReason");
    private static final AttributeKey<AuthorizationStateListener> AUTHORIZATION_STATE_LISTENER = AttributeKey.newInstance((String)"authorizationStateListener");
    private static final AttributeKey<Set<BoltPatchesListener>> BOLT_PATCHES_LISTENERS = AttributeKey.newInstance((String)"boltPatchesListeners");
    private static final AttributeKey<Long> CONNECTION_READ_TIMEOUT = AttributeKey.newInstance((String)"connectionReadTimeout");
    private static final AttributeKey<Boolean> TELEMETRY_ENABLED = AttributeKey.newInstance((String)"telemetryEnabled");
    private static final AttributeKey<Boolean> SSR_ENABLED = AttributeKey.newInstance((String)"ssr.enabled");

    private ChannelAttributes() {
    }

    public static String connectionId(Channel channel) {
        return ChannelAttributes.get(channel, CONNECTION_ID);
    }

    public static void setConnectionId(Channel channel, String id) {
        ChannelAttributes.setOnce(channel, CONNECTION_ID, id);
    }

    public static BoltProtocolVersion protocolVersion(Channel channel) {
        return ChannelAttributes.get(channel, PROTOCOL_VERSION);
    }

    public static void setProtocolVersion(Channel channel, BoltProtocolVersion version) {
        ChannelAttributes.setOnce(channel, PROTOCOL_VERSION, version);
    }

    public static void setServerAgent(Channel channel, String serverAgent) {
        ChannelAttributes.setOnce(channel, SERVER_AGENT, serverAgent);
    }

    public static String serverAgent(Channel channel) {
        return ChannelAttributes.get(channel, SERVER_AGENT);
    }

    public static BoltServerAddress serverAddress(Channel channel) {
        return ChannelAttributes.get(channel, ADDRESS);
    }

    public static void setServerAddress(Channel channel, BoltServerAddress address) {
        ChannelAttributes.setOnce(channel, ADDRESS, address);
    }

    public static long creationTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, CREATION_TIMESTAMP);
    }

    public static void setCreationTimestamp(Channel channel, long creationTimestamp) {
        ChannelAttributes.setOnce(channel, CREATION_TIMESTAMP, creationTimestamp);
    }

    public static Long lastUsedTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, LAST_USED_TIMESTAMP);
    }

    public static void setLastUsedTimestamp(Channel channel, long lastUsedTimestamp) {
        ChannelAttributes.set(channel, LAST_USED_TIMESTAMP, lastUsedTimestamp);
    }

    public static InboundMessageDispatcher messageDispatcher(Channel channel) {
        return ChannelAttributes.get(channel, MESSAGE_DISPATCHER);
    }

    public static void setMessageDispatcher(Channel channel, InboundMessageDispatcher messageDispatcher) {
        ChannelAttributes.setOnce(channel, MESSAGE_DISPATCHER, messageDispatcher);
    }

    public static String terminationReason(Channel channel) {
        return ChannelAttributes.get(channel, TERMINATION_REASON);
    }

    public static void setTerminationReason(Channel channel, String reason) {
        ChannelAttributes.setOnce(channel, TERMINATION_REASON, reason);
    }

    public static AuthorizationStateListener authorizationStateListener(Channel channel) {
        return ChannelAttributes.get(channel, AUTHORIZATION_STATE_LISTENER);
    }

    public static void setAuthorizationStateListener(Channel channel, AuthorizationStateListener authorizationStateListener) {
        ChannelAttributes.set(channel, AUTHORIZATION_STATE_LISTENER, authorizationStateListener);
    }

    public static Optional<Long> connectionReadTimeout(Channel channel) {
        return Optional.ofNullable(ChannelAttributes.get(channel, CONNECTION_READ_TIMEOUT));
    }

    public static void setConnectionReadTimeout(Channel channel, Long connectionReadTimeout) {
        ChannelAttributes.setOnce(channel, CONNECTION_READ_TIMEOUT, connectionReadTimeout);
    }

    public static void addBoltPatchesListener(Channel channel, BoltPatchesListener listener) {
        Set<BoltPatchesListener> boltPatchesListeners = ChannelAttributes.get(channel, BOLT_PATCHES_LISTENERS);
        if (boltPatchesListeners == null) {
            boltPatchesListeners = new HashSet<BoltPatchesListener>();
            ChannelAttributes.setOnce(channel, BOLT_PATCHES_LISTENERS, boltPatchesListeners);
        }
        boltPatchesListeners.add(listener);
    }

    public static Set<BoltPatchesListener> boltPatchesListeners(Channel channel) {
        Set<BoltPatchesListener> boltPatchesListeners = ChannelAttributes.get(channel, BOLT_PATCHES_LISTENERS);
        return boltPatchesListeners != null ? boltPatchesListeners : Collections.emptySet();
    }

    public static void setTelemetryEnabled(Channel channel, Boolean telemetryEnabled) {
        ChannelAttributes.setOnce(channel, TELEMETRY_ENABLED, telemetryEnabled);
    }

    public static boolean telemetryEnabled(Channel channel) {
        return Optional.ofNullable(ChannelAttributes.get(channel, TELEMETRY_ENABLED)).orElse(false);
    }

    public static void setSsrEnabled(Channel channel, Boolean telemetryEnabled) {
        ChannelAttributes.setOnce(channel, SSR_ENABLED, telemetryEnabled);
    }

    public static boolean ssrEnabled(Channel channel) {
        return Optional.ofNullable(ChannelAttributes.get(channel, SSR_ENABLED)).orElse(false);
    }

    private static <T> T get(Channel channel, AttributeKey<T> key) {
        return (T)channel.attr(key).get();
    }

    private static <T> void set(Channel channel, AttributeKey<T> key, T value) {
        channel.attr(key).set(value);
    }

    private static <T> void setOnce(Channel channel, AttributeKey<T> key, T value) {
        Object existingValue = channel.attr(key).setIfAbsent(value);
        if (existingValue != null) {
            throw new IllegalStateException("Unable to set " + key.name() + " because it is already set to " + existingValue);
        }
    }
}

