/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Map;
import java.util.concurrent.CompletionException;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.exceptions.DatabaseException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TokenExpiredException;
import org.neo4j.driver.exceptions.TransactionTerminatedException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.exceptions.UntrustedServerException;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.bolt.api.exception.BoltClientException;
import org.neo4j.driver.internal.bolt.api.exception.BoltConnectionAcquisitionException;
import org.neo4j.driver.internal.bolt.api.exception.BoltConnectionReadTimeoutException;
import org.neo4j.driver.internal.bolt.api.exception.BoltDiscoveryException;
import org.neo4j.driver.internal.bolt.api.exception.BoltFailureException;
import org.neo4j.driver.internal.bolt.api.exception.BoltGqlErrorException;
import org.neo4j.driver.internal.bolt.api.exception.BoltProtocolException;
import org.neo4j.driver.internal.bolt.api.exception.BoltServiceUnavailableException;
import org.neo4j.driver.internal.bolt.api.exception.BoltTransientException;
import org.neo4j.driver.internal.bolt.api.exception.BoltUnsupportedFeatureException;
import org.neo4j.driver.internal.bolt.api.exception.BoltUntrustedServerException;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.value.BoltValueFactory;

public class ErrorMapper {
    private static final ErrorMapper INSTANCE = new ErrorMapper();
    private static final BoltValueFactory BOLT_VALUE_FACTORY = BoltValueFactory.getInstance();

    public static ErrorMapper getInstance() {
        return INSTANCE;
    }

    protected ErrorMapper() {
    }

    <T> T mapAndTrow(Throwable throwable) {
        if ((throwable = this.map(throwable)) instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        throw new CompletionException(throwable);
    }

    Throwable map(Throwable throwable) {
        Throwable result = throwable = Futures.completionExceptionCause(throwable);
        try {
            if (throwable instanceof BoltFailureException) {
                BoltFailureException boltFailureException = (BoltFailureException)throwable;
                result = this.mapBoltFailureException(boltFailureException);
            } else if (throwable instanceof BoltGqlErrorException) {
                BoltGqlErrorException boltGqlErrorException = (BoltGqlErrorException)throwable;
                result = this.mapGqlCause(boltGqlErrorException);
            } else if (throwable instanceof BoltConnectionReadTimeoutException) {
                result = ConnectionReadTimeoutException.INSTANCE;
            } else if (throwable instanceof BoltServiceUnavailableException) {
                BoltServiceUnavailableException boltServiceUnavailableException = (BoltServiceUnavailableException)throwable;
                result = this.mapServiceUnavailable(boltServiceUnavailableException);
            } else if (throwable instanceof BoltProtocolException) {
                result = new ProtocolException(throwable.getMessage(), throwable);
            } else if (throwable instanceof BoltUnsupportedFeatureException) {
                result = new UnsupportedFeatureException(throwable.getMessage(), throwable);
            } else if (throwable instanceof BoltUntrustedServerException) {
                result = new UntrustedServerException(throwable.getMessage());
            } else if (throwable instanceof SSLHandshakeException) {
                result = new SecurityException("Failed to establish secured connection with the server", throwable);
            } else if (throwable instanceof BoltClientException) {
                result = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(throwable.getMessage()), "N/A", throwable.getMessage(), GqlStatusError.DIAGNOSTIC_RECORD, throwable);
            } else if (throwable instanceof BoltTransientException) {
                result = new TransientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(throwable.getMessage()), "N/A", throwable.getMessage(), GqlStatusError.DIAGNOSTIC_RECORD, throwable);
            } else if (throwable instanceof BoltConnectionAcquisitionException) {
                result = new SessionExpiredException(throwable.getMessage(), throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return result;
    }

    protected Throwable mapBoltFailureException(BoltFailureException boltFailureException) {
        String code = boltFailureException.code();
        Throwable nested = boltFailureException.gqlCause().map(this::mapGqlCause).orElse(null);
        return switch (ErrorMapper.extractErrorClass(code)) {
            case "ClientError" -> {
                if ("Security".equals(ErrorMapper.extractErrorSubClass(code))) {
                    if (code.equalsIgnoreCase("Neo.ClientError.Security.Unauthorized")) {
                        yield this.mapToNeo4jException(AuthenticationException::new, boltFailureException, nested);
                    }
                    if (code.equalsIgnoreCase("Neo.ClientError.Security.AuthorizationExpired")) {
                        yield this.mapToNeo4jException(AuthorizationExpiredException::new, boltFailureException, nested);
                    }
                    if (code.equalsIgnoreCase("Neo.ClientError.Security.TokenExpired")) {
                        yield this.mapToNeo4jException(TokenExpiredException::new, boltFailureException, nested);
                    }
                    yield this.mapToNeo4jException(SecurityException::new, boltFailureException, nested);
                }
                if (code.equalsIgnoreCase("Neo.ClientError.Database.DatabaseNotFound")) {
                    yield this.mapToNeo4jException(FatalDiscoveryException::new, boltFailureException, nested);
                }
                if (code.equalsIgnoreCase("Neo.ClientError.Transaction.Terminated")) {
                    yield this.mapToNeo4jException(TransactionTerminatedException::new, boltFailureException, nested);
                }
                yield this.mapToNeo4jException(ClientException::new, boltFailureException, nested);
            }
            case "TransientError" -> {
                if ("Neo.TransientError.Transaction.Terminated".equals(code)) {
                    yield new TransactionTerminatedException(boltFailureException.gqlStatus(), boltFailureException.statusDescription(), "Neo.ClientError.Transaction.Terminated", boltFailureException.getMessage(), BOLT_VALUE_FACTORY.toDriverMap(boltFailureException.diagnosticRecord()), nested);
                }
                if ("Neo.TransientError.Transaction.LockClientStopped".equals(code)) {
                    yield new ClientException(boltFailureException.gqlStatus(), boltFailureException.statusDescription(), "Neo.ClientError.Transaction.LockClientStopped", boltFailureException.getMessage(), BOLT_VALUE_FACTORY.toDriverMap(boltFailureException.diagnosticRecord()), nested);
                }
                yield this.mapToNeo4jException(TransientException::new, boltFailureException, nested);
            }
            default -> this.mapToNeo4jException(DatabaseException::new, boltFailureException, nested);
        };
    }

    protected Throwable mapGqlCause(BoltGqlErrorException boltGqlErrorException) {
        return new Neo4jException(boltGqlErrorException.gqlStatus(), boltGqlErrorException.statusDescription(), "N/A", boltGqlErrorException.getMessage(), BOLT_VALUE_FACTORY.toDriverMap(boltGqlErrorException.diagnosticRecord()), boltGqlErrorException.gqlCause().map(this::mapGqlCause).orElse(null));
    }

    protected Throwable mapServiceUnavailable(BoltServiceUnavailableException boltServiceUnavailableException) {
        ServiceUnavailableException result = null;
        for (Throwable suppressed : boltServiceUnavailableException.getSuppressed()) {
            if (!(suppressed instanceof BoltDiscoveryException)) continue;
            BoltDiscoveryException boltDiscoveryException = (BoltDiscoveryException)suppressed;
            if (result == null) {
                result = new ServiceUnavailableException(boltServiceUnavailableException.getMessage());
            }
            result.addSuppressed(new DiscoveryException(boltDiscoveryException.getMessage(), boltDiscoveryException));
        }
        if (result == null) {
            result = new ServiceUnavailableException(boltServiceUnavailableException.getMessage(), boltServiceUnavailableException);
        }
        return result;
    }

    private static String extractErrorClass(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 2) {
            return "";
        }
        return parts[1];
    }

    private static String extractErrorSubClass(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 3) {
            return "";
        }
        return parts[2];
    }

    private <T extends Neo4jException> T mapToNeo4jException(Neo4jExceptionBuilder<T> builder, BoltFailureException boltFailureException, Throwable cause) {
        return (T)((Neo4jException)builder.build(boltFailureException.gqlStatus(), boltFailureException.statusDescription(), boltFailureException.code(), boltFailureException.getMessage(), BOLT_VALUE_FACTORY.toDriverMap(boltFailureException.diagnosticRecord()), cause));
    }

    @FunctionalInterface
    private static interface Neo4jExceptionBuilder<T> {
        public T build(String var1, String var2, String var3, String var4, Map<String, Value> var5, Throwable var6);
    }
}

