/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pki;

import java.math.BigInteger;
import java.nio.ByteBuffer;

final class DerUtils {
    private static final byte INTEGER_TAG = 2;
    private static final byte OCTET_STRING_TAG = 4;
    private static final byte SEQUENCE_TAG = 48;

    private DerUtils() {
    }

    static BigInteger readDerInteger(ByteBuffer input) {
        int len = DerUtils.der(input, 2);
        byte[] value = new byte[len];
        input.get(value);
        return new BigInteger(1, value);
    }

    static byte[] readDerOctetString(ByteBuffer input) {
        int len = DerUtils.der(input, 4);
        byte[] value = new byte[len];
        input.get(value);
        return value;
    }

    static byte[] getDerContext(ByteBuffer input, byte contextTag) {
        int begin = input.position();
        while (input.hasRemaining()) {
            int start = input.position();
            byte tag = input.get();
            int length = DerUtils.getLength(input);
            if (DerUtils.isContextSpecific(tag, contextTag)) {
                return DerUtils.copyContext(input, start);
            }
            input.position(input.position() + length);
        }
        input.position(begin);
        return null;
    }

    static int beginDerSequence(ByteBuffer input) {
        return DerUtils.der(input, 48);
    }

    private static int der(ByteBuffer input, int expectedTag) {
        int tag = DerUtils.unsignedByte(input);
        if (tag != expectedTag) {
            throw new IllegalArgumentException(String.format("Expected tag '%02X' but found '%02X'", expectedTag, tag));
        }
        return DerUtils.getLength(input);
    }

    private static byte[] copyContext(ByteBuffer input, int dataStart) {
        input.position(dataStart);
        byte tag = input.get();
        if (DerUtils.isConstructed(tag)) {
            int length = DerUtils.getLength(input);
            byte[] data = new byte[length];
            input.get(data);
            return data;
        }
        throw new IllegalArgumentException("Unable to extract non-constructed data.");
    }

    private static boolean isContextSpecific(byte tag, byte contextTag) {
        if ((tag & 0xC0) == 128) {
            return (tag & 0x1F) == contextTag;
        }
        return false;
    }

    private static boolean isConstructed(byte tag) {
        return (tag & 0x20) == 32;
    }

    private static int getLength(ByteBuffer input) {
        int lengthByte = DerUtils.unsignedByte(input);
        if ((lengthByte & 0x80) == 0) {
            return lengthByte;
        }
        if ((lengthByte &= 0x7F) == 0) {
            throw new UnsupportedOperationException("Indefinite length is not allowed in DER.");
        }
        if (lengthByte > 2) {
            throw new IllegalArgumentException("Too big content.");
        }
        int len = 0;
        while (lengthByte-- > 0) {
            len <<= 8;
            len |= DerUtils.unsignedByte(input);
        }
        return len;
    }

    private static int unsignedByte(ByteBuffer input) {
        return input.get() & 0xFF;
    }
}

