/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.async.inbound;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.neo4j.driver.internal.bolt.api.GqlError;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.exception.BoltFailureException;
import org.neo4j.driver.internal.bolt.api.exception.BoltGqlErrorException;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.basicimpl.MessageIgnoredException;
import org.neo4j.driver.internal.bolt.basicimpl.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.bolt.basicimpl.logging.ChannelErrorLogger;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;

public class InboundMessageDispatcher
implements ResponseMessageHandler {
    private final Channel channel;
    private final Queue<ResponseHandler> handlers = new LinkedList<ResponseHandler>();
    private final System.Logger log;
    private final ChannelErrorLogger errorLog;
    private volatile boolean gracefullyClosed;
    private boolean fatalErrorOccurred;
    private Runnable beforeLastHandlerHook;
    private ResponseHandler autoReadManagingHandler;

    public InboundMessageDispatcher(Channel channel, LoggingProvider logging) {
        this.channel = Objects.requireNonNull(channel);
        this.log = new ChannelActivityLogger(channel, logging, this.getClass());
        this.errorLog = new ChannelErrorLogger(channel, logging);
    }

    public void enqueue(ResponseHandler handler) {
        if (this.fatalErrorOccurred) {
            this.log.log(System.Logger.Level.INFO, String.format("No handlers are accepted %s", handler.toString()));
            handler.onFailure(new IllegalStateException("No handlers are accepted after fatal error"));
        } else {
            this.handlers.add(handler);
            this.updateAutoReadManagingHandlerIfNeeded(handler);
        }
    }

    public void setBeforeLastHandlerHook(Runnable beforeLastHandlerHook) {
        if (!this.channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        this.beforeLastHandlerHook = beforeLastHandlerHook;
    }

    public int queuedHandlersCount() {
        return this.handlers.size();
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        if (this.log.isLoggable(System.Logger.Level.DEBUG)) {
            this.log.log(System.Logger.Level.DEBUG, "S: SUCCESS %s", meta);
        }
        this.invokeBeforeLastHandlerHook();
        ResponseHandler handler = this.removeHandler();
        handler.onSuccess(meta);
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        ResponseHandler handler;
        if (this.log.isLoggable(System.Logger.Level.DEBUG)) {
            this.log.log(System.Logger.Level.DEBUG, "S: RECORD %s", Arrays.toString(fields));
        }
        if ((handler = this.handlers.peek()) == null) {
            throw new IllegalStateException("No handler exists to handle RECORD message with fields: " + Arrays.toString(fields));
        }
        handler.onRecord(fields);
    }

    @Override
    public void handleFailureMessage(GqlError gqlError) {
        if (this.log.isLoggable(System.Logger.Level.DEBUG)) {
            this.log.log(System.Logger.Level.DEBUG, "S: FAILURE %s \"%s\"", gqlError.code(), gqlError.message());
        }
        BoltFailureException error = this.map(gqlError);
        this.invokeBeforeLastHandlerHook();
        ResponseHandler handler = this.removeHandler();
        handler.onFailure(error);
    }

    private BoltFailureException map(GqlError error) {
        String code = error.code();
        if ("Neo.TransientError.Transaction.Terminated".equals(code)) {
            code = "Neo.ClientError.Transaction.Terminated";
        } else if ("Neo.TransientError.Transaction.LockClientStopped".equals(code)) {
            code = "Neo.ClientError.Transaction.LockClientStopped";
        }
        return new BoltFailureException(code, error.message(), error.gqlStatus(), error.statusDescription(), error.diagnosticRecord(), this.mapNested(error.cause()));
    }

    private BoltGqlErrorException mapNested(GqlError error) {
        BoltGqlErrorException mapped = null;
        if (error != null) {
            mapped = new BoltGqlErrorException(error.message(), error.gqlStatus(), error.statusDescription(), error.diagnosticRecord(), this.mapNested(error.cause()));
        }
        return mapped;
    }

    @Override
    public void handleIgnoredMessage() {
        if (this.log.isLoggable(System.Logger.Level.DEBUG)) {
            this.log.log(System.Logger.Level.DEBUG, "S: IGNORED");
        }
        this.invokeBeforeLastHandlerHook();
        ResponseHandler handler = this.removeHandler();
        handler.onFailure(new MessageIgnoredException("The server has ignored the message"));
    }

    public void handleChannelInactive(Throwable cause) {
        if (!this.gracefullyClosed) {
            this.handleChannelError(cause);
        } else {
            while (!this.handlers.isEmpty()) {
                ResponseHandler handler = this.removeHandler();
                handler.onFailure(cause);
            }
            this.channel.close();
        }
    }

    public void handleChannelError(Throwable error) {
        this.fatalErrorOccurred = true;
        while (!this.handlers.isEmpty()) {
            ResponseHandler handler = this.removeHandler();
            handler.onFailure(error);
        }
        this.errorLog.traceOrDebug("Closing channel because of a failure", error);
        this.channel.close();
    }

    public boolean fatalErrorOccurred() {
        return this.fatalErrorOccurred;
    }

    ResponseHandler autoReadManagingHandler() {
        return this.autoReadManagingHandler;
    }

    private ResponseHandler removeHandler() {
        ResponseHandler handler = this.handlers.remove();
        if (handler == this.autoReadManagingHandler) {
            this.updateAutoReadManagingHandler(null);
        }
        return handler;
    }

    private void updateAutoReadManagingHandlerIfNeeded(ResponseHandler handler) {
        if (handler.canManageAutoRead()) {
            this.updateAutoReadManagingHandler(handler);
        }
    }

    private void updateAutoReadManagingHandler(ResponseHandler newHandler) {
        if (this.autoReadManagingHandler != null) {
            this.autoReadManagingHandler.disableAutoReadManagement();
            this.channel.config().setAutoRead(true);
        }
        this.autoReadManagingHandler = newHandler;
    }

    private void invokeBeforeLastHandlerHook() {
        if (this.handlers.size() == 1 && this.beforeLastHandlerHook != null) {
            this.beforeLastHandlerHook.run();
        }
    }

    System.Logger getLog() {
        return this.log;
    }

    System.Logger getErrorLog() {
        return this.errorLog;
    }
}

