/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.async.inbound;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.bolt.api.exception.BoltServiceUnavailableException;

public class ConnectTimeoutHandler
extends ReadTimeoutHandler {
    private final long timeoutMillis;
    private boolean triggered;

    public ConnectTimeoutHandler(long timeoutMillis) {
        super(timeoutMillis, TimeUnit.MILLISECONDS);
        this.timeoutMillis = timeoutMillis;
    }

    protected void readTimedOut(ChannelHandlerContext ctx) {
        if (!this.triggered) {
            this.triggered = true;
            ctx.fireExceptionCaught((Throwable)this.unableToConnectError());
        }
    }

    private BoltServiceUnavailableException unableToConnectError() {
        return new BoltServiceUnavailableException("Unable to establish connection in " + this.timeoutMillis + "ms");
    }
}

