/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.api;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public record NotificationSeverity(Type type, int level) implements Comparable<NotificationSeverity>
{
    public static final NotificationSeverity OFF = new NotificationSeverity(Type.OFF, Integer.MAX_VALUE);
    public static final NotificationSeverity INFORMATION = new NotificationSeverity(Type.INFORMATION, 800);
    public static final NotificationSeverity WARNING = new NotificationSeverity(Type.WARNING, 900);

    public NotificationSeverity {
        Objects.requireNonNull(type, "type must not be null");
    }

    @Override
    public int compareTo(NotificationSeverity severity) {
        return Integer.compare(this.level, severity.level());
    }

    public static Optional<NotificationSeverity> valueOf(String value) {
        return Arrays.stream(Type.values()).filter(type -> type.toString().equals(value)).findFirst().map(type -> switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.INFORMATION -> INFORMATION;
            case Type.WARNING -> WARNING;
            case Type.OFF -> OFF;
        });
    }

    public static enum Type {
        INFORMATION,
        WARNING,
        OFF;

    }
}

