/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.MetricsListener;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.routedimpl.RoutedBoltConnection;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.Rediscovery;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTable;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableRegistryImpl;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.bolt.routedimpl.util.FutureUtil;

public class RoutedBoltConnectionProvider
implements BoltConnectionProvider {
    private static final String CONNECTION_ACQUISITION_COMPLETION_FAILURE_MESSAGE = "Connection acquisition failed for all available addresses.";
    private static final String CONNECTION_ACQUISITION_COMPLETION_EXCEPTION_MESSAGE = "Failed to obtain connection towards %s server. Known routing table is: %s";
    private static final String CONNECTION_ACQUISITION_ATTEMPT_FAILURE_MESSAGE = "Failed to obtain a connection towards address %s, will try other addresses if available. Complete failure is reported separately from this entry.";
    private final LoggingProvider logging;
    private final System.Logger log;
    private final Supplier<BoltConnectionProvider> boltConnectionProviderSupplier;
    private final Map<BoltServerAddress, BoltConnectionProvider> addressToProvider = new HashMap<BoltServerAddress, BoltConnectionProvider>();
    private final Function<BoltServerAddress, Set<BoltServerAddress>> resolver;
    private final DomainNameResolver domainNameResolver;
    private final Map<BoltServerAddress, Integer> addressToInUseCount = new HashMap<BoltServerAddress, Integer>();
    private final LoadBalancingStrategy loadBalancingStrategy;
    private final long routingTablePurgeDelayMs;
    private Rediscovery rediscovery;
    private RoutingTableRegistry registry;
    private RoutingContext routingContext;
    private BoltAgent boltAgent;
    private String userAgent;
    private int connectTimeoutMillis;
    private CompletableFuture<Void> closeFuture;
    private final Clock clock;
    private MetricsListener metricsListener;

    public RoutedBoltConnectionProvider(Supplier<BoltConnectionProvider> boltConnectionProviderSupplier, Function<BoltServerAddress, Set<BoltServerAddress>> resolver, DomainNameResolver domainNameResolver, long routingTablePurgeDelayMs, Rediscovery rediscovery, Clock clock, LoggingProvider logging) {
        this.boltConnectionProviderSupplier = Objects.requireNonNull(boltConnectionProviderSupplier);
        this.resolver = Objects.requireNonNull(resolver);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.loadBalancingStrategy = new LeastConnectedLoadBalancingStrategy(this::getInUseCount, logging);
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
        this.rediscovery = rediscovery;
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public synchronized CompletionStage<Void> init(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        this.routingContext = routingContext;
        this.boltAgent = boltAgent;
        this.userAgent = userAgent;
        this.connectTimeoutMillis = connectTimeoutMillis;
        if (this.rediscovery == null) {
            this.rediscovery = new RediscoveryImpl(address, this.resolver, this.logging, this.domainNameResolver);
        }
        this.registry = new RoutingTableRegistryImpl(this::get, this.rediscovery, this.clock, this.logging, this.routingTablePurgeDelayMs, this::shutdownUnusedProviders);
        this.metricsListener = Objects.requireNonNull(metricsListener);
        return CompletableFuture.completedStage(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<BoltConnection> connect(SecurityPlan securityPlan, DatabaseName databaseName, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, AccessMode mode, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, Consumer<DatabaseName> databaseNameConsumer) {
        RoutingTableRegistry registry;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            if (this.closeFuture != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
            }
            registry = this.registry;
        }
        AtomicReference handlerRef = new AtomicReference();
        CompletableFuture<DatabaseName> databaseNameFuture = databaseName == null ? new CompletableFuture<DatabaseName>() : CompletableFuture.completedFuture(databaseName);
        databaseNameFuture.whenComplete((name, throwable) -> {
            if (name != null) {
                databaseNameConsumer.accept((DatabaseName)name);
            }
        });
        return registry.ensureRoutingTable(securityPlan, databaseNameFuture, mode, bookmarks, impersonatedUser, authMapStageSupplier, minVersion).thenApply(routingTableHandler -> {
            handlerRef.set(routingTableHandler);
            return routingTableHandler;
        }).thenCompose(routingTableHandler -> this.acquire(securityPlan, mode, routingTableHandler.routingTable(), authMapStageSupplier, routingTableHandler.routingTable().database(), Set.of(), impersonatedUser, minVersion, notificationConfig)).thenApply(boltConnection -> new RoutedBoltConnection((BoltConnection)boltConnection, (RoutingTableHandler)handlerRef.get(), mode, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> verifyConnectivity(SecurityPlan securityPlan, Map<String, Value> authMap) {
        RoutingTableRegistry registry;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            registry = this.registry;
        }
        return this.supportsMultiDb(securityPlan, authMap).thenCompose(supports -> registry.ensureRoutingTable(securityPlan, supports != false ? CompletableFuture.completedFuture(DatabaseNameUtil.database("system")) : CompletableFuture.completedFuture(DatabaseNameUtil.defaultDatabase()), AccessMode.READ, Collections.emptySet(), null, () -> CompletableFuture.completedStage(authMap), null)).handle((ignored, error) -> {
            if (error != null) {
                Throwable cause = FutureUtil.completionExceptionCause(error);
                if (cause instanceof ServiceUnavailableException) {
                    throw FutureUtil.asCompletionException(new ServiceUnavailableException("Unable to connect to database management service, ensure the database is running and that there is a working network connection to it.", cause));
                }
                throw FutureUtil.asCompletionException(cause);
            }
            return null;
        });
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.detectFeature(securityPlan, authMap, "Failed to perform multi-databases feature detection with the following servers: ", boltConnection -> boltConnection.protocolVersion().compareTo(new BoltProtocolVersion(4, 0)) >= 0);
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.detectFeature(securityPlan, authMap, "Failed to perform session auth feature detection with the following servers: ", boltConnection -> new BoltProtocolVersion(5, 1).compareTo(boltConnection.protocolVersion()) <= 0);
    }

    private synchronized void shutdownUnusedProviders(Set<BoltServerAddress> addressesToRetain) {
        Iterator<Map.Entry<BoltServerAddress, BoltConnectionProvider>> iterator = this.addressToProvider.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BoltServerAddress, BoltConnectionProvider> entry = iterator.next();
            BoltServerAddress address = entry.getKey();
            if (addressesToRetain.contains(address) || this.getInUseCount(address) != 0) continue;
            entry.getValue().close();
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Boolean> detectFeature(SecurityPlan securityPlan, Map<String, Value> authMap, String baseErrorMessagePrefix, Function<BoltConnection, Boolean> featureDetectionFunction) {
        List<BoltServerAddress> addresses;
        Rediscovery rediscovery;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            rediscovery = this.rediscovery;
        }
        try {
            addresses = rediscovery.resolve();
        }
        catch (Throwable error) {
            return CompletableFuture.failedFuture(error);
        }
        CompletableFuture<Object> result = CompletableFuture.completedFuture(null);
        ServiceUnavailableException baseError = new ServiceUnavailableException(baseErrorMessagePrefix + addresses);
        for (BoltServerAddress address : addresses) {
            result = FutureUtil.onErrorContinue(result, baseError, completionError -> {
                Throwable error = FutureUtil.completionExceptionCause(completionError);
                if (error instanceof SecurityException) {
                    return CompletableFuture.failedFuture(error);
                }
                return this.get(address).connect(securityPlan, null, () -> CompletableFuture.completedStage(authMap), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}).thenCompose(boltConnection -> {
                    Boolean featureDetected = (Boolean)featureDetectionFunction.apply((BoltConnection)boltConnection);
                    return boltConnection.close().thenApply(ignored -> featureDetected);
                });
            });
        }
        return FutureUtil.onErrorContinue(result, baseError, completionError -> {
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error instanceof SecurityException) {
                return CompletableFuture.failedFuture(error);
            }
            return CompletableFuture.failedFuture(baseError);
        });
    }

    private CompletionStage<BoltConnection> acquire(SecurityPlan securityPlan, AccessMode mode, RoutingTable routingTable, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, DatabaseName database, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        CompletableFuture<BoltConnection> result = new CompletableFuture<BoltConnection>();
        ArrayList<Throwable> attemptExceptions = new ArrayList<Throwable>();
        this.acquire(securityPlan, mode, routingTable, result, authMapStageSupplier, attemptExceptions, database, bookmarks, impersonatedUser, minVersion, notificationConfig);
        return result;
    }

    private void acquire(SecurityPlan securityPlan, AccessMode mode, RoutingTable routingTable, CompletableFuture<BoltConnection> result, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, List<Throwable> attemptErrors, DatabaseName database, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        List<BoltServerAddress> addresses = RoutedBoltConnectionProvider.getAddressesByMode(mode, routingTable);
        this.log.log(System.Logger.Level.DEBUG, "Addresses: " + addresses);
        BoltServerAddress address = this.selectAddress(mode, addresses);
        this.log.log(System.Logger.Level.DEBUG, "Selected address: " + address);
        if (address == null) {
            SessionExpiredException completionError2 = new SessionExpiredException(String.format(CONNECTION_ACQUISITION_COMPLETION_EXCEPTION_MESSAGE, new Object[]{mode, routingTable}));
            attemptErrors.forEach(completionError2::addSuppressed);
            this.log.log(System.Logger.Level.ERROR, CONNECTION_ACQUISITION_COMPLETION_FAILURE_MESSAGE, (Throwable)completionError2);
            result.completeExceptionally(completionError2);
            return;
        }
        this.get(address).connect(securityPlan, database, authMapStageSupplier, mode, bookmarks, impersonatedUser, minVersion, notificationConfig, ignored -> {}).whenComplete((connection, completionError) -> {
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error != null) {
                if (error instanceof ServiceUnavailableException) {
                    String attemptMessage = String.format(CONNECTION_ACQUISITION_ATTEMPT_FAILURE_MESSAGE, address);
                    this.log.log(System.Logger.Level.WARNING, attemptMessage);
                    this.log.log(System.Logger.Level.DEBUG, attemptMessage, error);
                    attemptErrors.add(error);
                    routingTable.forget(address);
                    CompletableFuture.runAsync(() -> this.lambda$acquire$16(securityPlan, mode, routingTable, result, (Supplier)authMapStageSupplier, attemptErrors, database, bookmarks, impersonatedUser, minVersion, notificationConfig));
                } else {
                    result.completeExceptionally(error);
                }
            } else {
                this.incrementInUseCount(address);
                result.complete((BoltConnection)connection);
            }
        });
    }

    private BoltServerAddress selectAddress(AccessMode mode, List<BoltServerAddress> addresses) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> this.loadBalancingStrategy.selectReader(addresses);
            case AccessMode.WRITE -> this.loadBalancingStrategy.selectWriter(addresses);
        };
    }

    private static List<BoltServerAddress> getAddressesByMode(AccessMode mode, RoutingTable routingTable) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> routingTable.readers();
            case AccessMode.WRITE -> routingTable.writers();
        };
    }

    private synchronized int getInUseCount(BoltServerAddress address) {
        return this.addressToInUseCount.getOrDefault(address, 0);
    }

    private synchronized void incrementInUseCount(BoltServerAddress address) {
        this.addressToInUseCount.merge(address, 1, Integer::sum);
    }

    synchronized void decrementInUseCount(BoltServerAddress address) {
        this.addressToInUseCount.compute(address, (ignored, value) -> {
            if (value == null) {
                return null;
            }
            Integer n = value;
            value = value - 1;
            return value > 0 ? value : null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            if (this.closeFuture == null) {
                CompletableFuture[] futures = new CompletableFuture[this.addressToProvider.size()];
                Iterator<BoltConnectionProvider> iterator = this.addressToProvider.values().iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    futures[index++] = iterator.next().close().toCompletableFuture();
                    iterator.remove();
                }
                this.closeFuture = CompletableFuture.allOf(futures);
            }
            closeFuture = this.closeFuture;
        }
        return closeFuture;
    }

    private synchronized BoltConnectionProvider get(BoltServerAddress address) {
        BoltConnectionProvider provider = this.addressToProvider.get(address);
        if (provider == null) {
            provider = this.boltConnectionProviderSupplier.get();
            provider.init(address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, this.metricsListener);
            this.addressToProvider.put(address, provider);
        }
        return provider;
    }

    private /* synthetic */ void lambda$acquire$16(SecurityPlan securityPlan, AccessMode mode, RoutingTable routingTable, CompletableFuture result, Supplier authMapStageSupplier, List attemptErrors, DatabaseName database, Set bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        this.acquire(securityPlan, mode, routingTable, result, authMapStageSupplier, attemptErrors, database, bookmarks, impersonatedUser, minVersion, notificationConfig);
    }
}

