/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.SecurityRetryableException;
import org.neo4j.driver.internal.async.DelegatingBoltConnection;
import org.neo4j.driver.internal.async.ErrorMappingResponseHandler;
import org.neo4j.driver.internal.bolt.api.AuthData;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.security.InternalAuthToken;

final class BoltConnectionWithAuthTokenManager
extends DelegatingBoltConnection {
    private final AuthTokenManager authTokenManager;

    public BoltConnectionWithAuthTokenManager(BoltConnection delegate, AuthTokenManager authTokenManager) {
        super(delegate);
        this.authTokenManager = Objects.requireNonNull(authTokenManager);
    }

    @Override
    public CompletionStage<Void> flush(ResponseHandler handler) {
        return this.delegate.flush(new ErrorMappingResponseHandler(handler, this::mapSecurityError));
    }

    private Throwable mapSecurityError(Throwable throwable) {
        if (throwable instanceof SecurityException) {
            SecurityException securityException = (SecurityException)throwable;
            AuthData authData = this.delegate.authData().toCompletableFuture().getNow(null);
            if (authData != null && this.authTokenManager.handleSecurityException(new InternalAuthToken(authData.authMap()), securityException)) {
                throwable = new SecurityRetryableException(securityException);
            }
        }
        return throwable;
    }
}

