/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.cursor.AbstractRecordStateResponseHandler;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.summary.ResultSummary;

public class RxResultCursorImpl
extends AbstractRecordStateResponseHandler
implements RxResultCursor,
ResponseHandler {
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_last");
    private final BoltConnection boltConnection;
    private final Query query;
    private final RunSummary runSummary;
    private final Throwable runError;
    private final Consumer<DatabaseBookmark> bookmarkConsumer;
    private final Consumer<Throwable> throwableConsumer;
    private final Supplier<Throwable> termSupplier;
    private final boolean closeOnSummary;
    private final CompletableFuture<ResultSummary> summaryFuture = new CompletableFuture();
    private final boolean legacyNotifications;
    private final CompletableFuture<Void> consumedFuture = new CompletableFuture();
    private State state;
    private long outstandingDemand;
    private BiConsumer<Record, Throwable> recordConsumer;
    private boolean discardPending;
    private boolean runErrorExposed;
    private boolean summaryExposed;

    public RxResultCursorImpl(BoltConnection boltConnection, Query query, RunSummary runSummary, Throwable runError, Supplier<Throwable> throwableSupplier, Consumer<DatabaseBookmark> bookmarkConsumer, Consumer<Throwable> throwableConsumer, boolean closeOnSummary, Supplier<Throwable> termSupplier) {
        this.boltConnection = boltConnection;
        this.legacyNotifications = new BoltProtocolVersion(5, 5).compareTo(boltConnection.protocolVersion()) > 0;
        this.query = query;
        if (runSummary != null) {
            this.runSummary = runSummary;
            this.state = State.READY;
        } else {
            this.runSummary = new RunSummary(){

                @Override
                public long queryId() {
                    return -1L;
                }

                @Override
                public List<String> keys() {
                    return List.of();
                }

                @Override
                public long resultAvailableAfter() {
                    return -1L;
                }
            };
            this.state = State.FAILED;
            this.summaryFuture.completeExceptionally(runError);
        }
        this.runError = runError;
        this.bookmarkConsumer = bookmarkConsumer;
        this.closeOnSummary = closeOnSummary;
        this.throwableConsumer = throwableConsumer;
        this.termSupplier = termSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable throwable) {
        Runnable runnable;
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            if (this.state == State.FAILED) {
                return;
            }
            this.state = State.FAILED;
            ResultSummary summary = METADATA_EXTRACTOR.extractSummary(this.query, this.boltConnection, this.runSummary.resultAvailableAfter(), Collections.emptyMap(), this.legacyNotifications, this.generateGqlStatusObject(this.runSummary.keys()));
            runnable = this.recordConsumer != null ? () -> {
                CompletionStage<Object> closeStage = this.closeOnSummary ? this.boltConnection.close() : CompletableFuture.completedStage(null);
                closeStage.whenComplete((ignored, closeThrowable) -> {
                    Throwable error = Futures.completionExceptionCause(closeThrowable);
                    if (error != null) {
                        throwable.addSuppressed(error);
                    }
                    this.throwableConsumer.accept(throwable);
                    this.recordConsumer.accept(null, throwable);
                    this.summaryFuture.complete(summary);
                    this.dispose();
                });
            } : () -> {
                CompletionStage<Object> closeStage = this.closeOnSummary ? this.boltConnection.close() : CompletableFuture.completedStage(null);
                closeStage.whenComplete((ignored, closeThrowable) -> {
                    Throwable error = Futures.completionExceptionCause(closeThrowable);
                    if (error != null) {
                        throwable.addSuppressed(error);
                    }
                    this.throwableConsumer.accept(throwable);
                    this.summaryFuture.completeExceptionally(throwable);
                    this.dispose();
                });
            };
        }
        runnable.run();
    }

    @Override
    public void onIgnored() {
        Throwable throwable = this.termSupplier.get();
        if (throwable == null) {
            String message = "A message has been ignored during result streaming.";
            throwable = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
        }
        this.onError(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecord(Value[] fields) {
        InternalRecord record = new InternalRecord(this.runSummary.keys(), fields);
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.HAD_RECORD);
            this.decrementDemand();
        }
        this.recordConsumer.accept(record, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPullSummary(PullSummary summary) {
        Throwable term = this.termSupplier.get();
        if (term == null) {
            CompletableFuture<ResultSummary> resultSummaryFuture;
            if (summary.hasMore()) {
                RxResultCursorImpl rxResultCursorImpl = this;
                synchronized (rxResultCursorImpl) {
                    if (this.discardPending) {
                        this.discardPending = false;
                        this.state = State.DISCARDING;
                        this.boltConnection.discard(this.runSummary.queryId(), -1L).thenCompose(conn -> conn.flush(this)).whenComplete((ignored, throwable) -> {
                            Throwable error = Futures.completionExceptionCause(throwable);
                            if (error != null) {
                                this.onError(error);
                            }
                        });
                    } else {
                        long demand = this.getDemand();
                        if (demand != 0L) {
                            this.state = State.STREAMING;
                            this.boltConnection.pull(this.runSummary.queryId(), demand > 0L ? demand : -1L).thenCompose(conn -> conn.flush(this)).whenComplete((ignored, throwable) -> {
                                Throwable error = Futures.completionExceptionCause(throwable);
                                if (error != null) {
                                    this.onError(error);
                                }
                            });
                        } else {
                            this.state = State.READY;
                        }
                    }
                }
            }
            AtomicReference<ResultSummary> resultSummaryRef = new AtomicReference<ResultSummary>();
            Throwable summaryError = null;
            RxResultCursorImpl rxResultCursorImpl = this;
            synchronized (rxResultCursorImpl) {
                resultSummaryFuture = this.summaryFuture;
                try {
                    resultSummaryRef.set(METADATA_EXTRACTOR.extractSummary(this.query, this.boltConnection, this.runSummary.resultAvailableAfter(), summary.metadata(), this.legacyNotifications, this.generateGqlStatusObject(this.runSummary.keys())));
                    this.state = State.SUCCEDED;
                }
                catch (Throwable throwable2) {
                    summaryError = throwable2;
                }
            }
            if (summaryError == null) {
                String bookmarkStr;
                Map<String, Value> metadata = summary.metadata();
                Value bookmarkValue = metadata.get("bookmark");
                if (bookmarkValue != null && !bookmarkValue.isNull() && bookmarkValue.hasType(InternalTypeSystem.TYPE_SYSTEM.STRING()) && !(bookmarkStr = bookmarkValue.asString()).isEmpty()) {
                    DatabaseBookmark databaseBookmark = new DatabaseBookmark(null, Bookmark.from(bookmarkStr));
                    this.bookmarkConsumer.accept(databaseBookmark);
                }
                this.recordConsumer.accept(null, null);
                CompletionStage<Object> closeStage = this.closeOnSummary ? this.boltConnection.close() : CompletableFuture.completedStage(null);
                closeStage.whenComplete((ignored, throwable) -> {
                    Throwable error = Futures.completionExceptionCause(throwable);
                    if (error != null) {
                        resultSummaryFuture.completeExceptionally(error);
                    } else {
                        resultSummaryFuture.complete((ResultSummary)resultSummaryRef.get());
                    }
                });
                this.dispose();
            } else {
                this.onError(summaryError);
            }
        } else {
            this.onError(term);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDiscardSummary(DiscardSummary summary) {
        CompletableFuture<ResultSummary> resultSummaryFuture;
        AtomicReference<ResultSummary> resultSummaryRef = new AtomicReference<ResultSummary>();
        Throwable summaryError = null;
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            resultSummaryFuture = this.summaryFuture;
            try {
                resultSummaryRef.set(METADATA_EXTRACTOR.extractSummary(this.query, this.boltConnection, this.runSummary.resultAvailableAfter(), summary.metadata(), this.legacyNotifications, this.generateGqlStatusObject(this.runSummary.keys())));
                this.state = State.SUCCEDED;
            }
            catch (Throwable throwable2) {
                summaryError = throwable2;
            }
        }
        if (summaryError == null) {
            String bookmarkStr;
            Map<String, Value> metadata = summary.metadata();
            Value bookmarkValue = metadata.get("bookmark");
            if (bookmarkValue != null && !bookmarkValue.isNull() && bookmarkValue.hasType(InternalTypeSystem.TYPE_SYSTEM.STRING()) && !(bookmarkStr = bookmarkValue.asString()).isEmpty()) {
                DatabaseBookmark databaseBookmark = new DatabaseBookmark(null, Bookmark.from(bookmarkStr));
                this.bookmarkConsumer.accept(databaseBookmark);
            }
            CompletionStage<Object> closeStage = this.closeOnSummary ? this.boltConnection.close() : CompletableFuture.completedStage(null);
            closeStage.whenComplete((ignored, throwable) -> {
                Throwable error = Futures.completionExceptionCause(throwable);
                if (error != null) {
                    resultSummaryFuture.completeExceptionally(error);
                } else {
                    resultSummaryFuture.complete((ResultSummary)resultSummaryRef.get());
                }
            });
            this.dispose();
        } else {
            this.onError(summaryError);
        }
    }

    @Override
    public synchronized CompletionStage<Throwable> discardAllFailureAsync() {
        boolean summaryExposed = this.summaryExposed;
        return this.summaryAsync().thenApply(ignored -> null).exceptionally(throwable -> this.runErrorExposed || summaryExposed ? null : throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Throwable> pullAllFailureAsync() {
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            if (this.recordConsumer != null && !this.isDone()) {
                return CompletableFuture.completedFuture(new TransactionNestingException("You cannot run another query or begin a new transaction in the same session before you've fully consumed the previous run result."));
            }
        }
        return this.discardAllFailureAsync();
    }

    @Override
    public CompletionStage<Void> consumed() {
        return this.consumedFuture;
    }

    @Override
    public List<String> keys() {
        return this.runSummary.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        Objects.requireNonNull(recordConsumer);
        Runnable runnable = () -> {};
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            if (this.recordConsumer == null) {
                this.recordConsumer = recordConsumer;
                if (this.runError != null) {
                    this.runErrorExposed = true;
                    runnable = () -> recordConsumer.accept(null, this.runError);
                }
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<ResultSummary> summaryAsync() {
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            if (this.summaryExposed) {
                return this.summaryFuture;
            }
            this.summaryExposed = true;
            switch (this.state) {
                case SUCCEDED: 
                case FAILED: 
                case DISCARDING: {
                    break;
                }
                case READY: {
                    Throwable term = this.termSupplier.get();
                    if (term == null) {
                        this.state = State.DISCARDING;
                        this.boltConnection.discard(this.runSummary.queryId(), -1L).thenCompose(conn -> conn.flush(this)).whenComplete((ignored, throwable) -> {
                            Throwable error = Futures.completionExceptionCause(throwable);
                            if (error != null) {
                                this.onError(error);
                            }
                        });
                        break;
                    }
                    this.onError(term);
                    break;
                }
                case STREAMING: {
                    this.discardPending = true;
                }
            }
        }
        CompletableFuture<ResultSummary> future = new CompletableFuture<ResultSummary>();
        this.summaryFuture.whenComplete((summary, throwable) -> {
            if ((throwable = Futures.completionExceptionCause(throwable)) != null) {
                this.consumedFuture.completeExceptionally((Throwable)throwable);
                future.completeExceptionally((Throwable)throwable);
            } else {
                this.consumedFuture.complete(null);
                future.complete((ResultSummary)summary);
            }
        });
        return future;
    }

    @Override
    public synchronized boolean isDone() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.DISCARDING, State.READY, State.STREAMING -> false;
            case State.FAILED -> {
                if (this.runError == null || this.runErrorExposed) {
                    yield true;
                }
                yield false;
            }
            case State.SUCCEDED -> true;
        };
    }

    @Override
    public Throwable getRunError() {
        this.runErrorExposed = true;
        return this.runError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> rollback() {
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            this.state = State.SUCCEDED;
        }
        this.summaryFuture.complete(null);
        final CompletableFuture future = new CompletableFuture();
        this.boltConnection.reset().thenCompose(conn -> conn.flush(new ResponseHandler(){

            @Override
            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                future.complete(null);
            }
        })).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return ((CompletableFuture)future.thenCompose(ignored -> this.boltConnection.close())).exceptionally(throwable -> null);
    }

    private synchronized void dispose() {
        this.recordConsumer = null;
    }

    private synchronized long appendDemand(long n) {
        if (n == Long.MAX_VALUE) {
            this.outstandingDemand = -1L;
        } else {
            try {
                this.outstandingDemand = Math.addExact(this.outstandingDemand, n);
            }
            catch (ArithmeticException ex) {
                this.outstandingDemand = -1L;
            }
        }
        return this.outstandingDemand;
    }

    private synchronized long getDemand() {
        return this.outstandingDemand;
    }

    private synchronized void decrementDemand() {
        if (this.outstandingDemand > 0L) {
            --this.outstandingDemand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("n must not be 0 or negative");
        }
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            this.updateRecordState(AbstractRecordStateResponseHandler.RecordState.NO_RECORD);
            switch (this.state) {
                case READY: {
                    Throwable term = this.termSupplier.get();
                    if (term == null) {
                        long request = this.appendDemand(n);
                        this.state = State.STREAMING;
                        this.boltConnection.pull(this.runSummary.queryId(), request).thenCompose(conn -> conn.flush(this)).whenComplete((ignored, throwable) -> {
                            Throwable error = Futures.completionExceptionCause(throwable);
                            if (error != null) {
                                this.onError(error);
                            }
                        });
                        break;
                    }
                    this.onError(term);
                    break;
                }
                case STREAMING: {
                    this.appendDemand(n);
                    break;
                }
                case FAILED: {
                    if (this.recordConsumer == null || this.runErrorExposed) break;
                    this.recordConsumer.accept(null, this.getRunError());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RxResultCursorImpl rxResultCursorImpl = this;
        synchronized (rxResultCursorImpl) {
            switch (this.state) {
                case READY: {
                    this.state = State.DISCARDING;
                    this.boltConnection.discard(this.runSummary.queryId(), -1L).thenCompose(conn -> conn.flush(this)).whenComplete((ignored, throwable) -> {
                        Throwable error;
                        if (throwable != null && (error = Futures.completionExceptionCause(throwable)) != null) {
                            this.onError(error);
                        }
                    });
                    break;
                }
                case STREAMING: {
                    this.discardPending = true;
                    break;
                }
            }
        }
    }

    private static enum State {
        READY,
        STREAMING,
        DISCARDING,
        FAILED,
        SUCCEDED;

    }
}

