/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl.cluster;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.AuthTokenManagerExecutionException;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ClusterComposition;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.api.exception.MinVersionAcquisitionException;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.Rediscovery;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.ResolvedBoltServerAddress;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTable;
import org.neo4j.driver.internal.bolt.routedimpl.util.FutureUtil;

public class RediscoveryImpl
implements Rediscovery {
    private static final String NO_ROUTERS_AVAILABLE = "Could not perform discovery for database '%s'. No routing server available.";
    private static final String RECOVERABLE_ROUTING_ERROR = "Failed to update routing table with server '%s'.";
    private static final String RECOVERABLE_DISCOVERY_ERROR_WITH_SERVER = "Received a recoverable discovery error with server '%s', will continue discovery with other routing servers if available. Complete failure is reported separately from this entry.";
    private static final String TRANSACTION_INVALID_BOOKMARK_CODE = "Neo.ClientError.Transaction.InvalidBookmark";
    private static final String TRANSACTION_INVALID_BOOKMARK_MIXTURE_CODE = "Neo.ClientError.Transaction.InvalidBookmarkMixture";
    private static final String STATEMENT_ARGUMENT_ERROR_CODE = "Neo.ClientError.Statement.ArgumentError";
    private static final String REQUEST_INVALID_CODE = "Neo.ClientError.Request.Invalid";
    private static final String STATEMENT_TYPE_ERROR_CODE = "Neo.ClientError.Statement.TypeError";
    private final BoltServerAddress initialRouter;
    private final System.Logger log;
    private final Function<BoltServerAddress, Set<BoltServerAddress>> resolver;
    private final DomainNameResolver domainNameResolver;

    public RediscoveryImpl(BoltServerAddress initialRouter, Function<BoltServerAddress, Set<BoltServerAddress>> resolver, LoggingProvider logging, DomainNameResolver domainNameResolver) {
        this.initialRouter = initialRouter;
        this.log = logging.getLog(this.getClass());
        this.resolver = resolver;
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
    }

    @Override
    public CompletionStage<ClusterCompositionLookupResult> lookupClusterComposition(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion) {
        CompletableFuture<ClusterCompositionLookupResult> result = new CompletableFuture<ClusterCompositionLookupResult>();
        ServiceUnavailableException baseError = new ServiceUnavailableException(String.format(NO_ROUTERS_AVAILABLE, routingTable.database().description()));
        this.lookupClusterComposition(securityPlan, routingTable, connectionProviderGetter, result, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError);
        return result;
    }

    private void lookupClusterComposition(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, CompletableFuture<ClusterCompositionLookupResult> result, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplierp, BoltProtocolVersion minVersion, Throwable baseError) {
        this.lookup(securityPlan, routingTable, connectionProviderGetter, bookmarks, impersonatedUser, authMapStageSupplierp, minVersion, baseError).whenComplete((compositionLookupResult, completionError) -> {
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error != null) {
                result.completeExceptionally(error);
            } else if (compositionLookupResult != null) {
                result.complete((ClusterCompositionLookupResult)compositionLookupResult);
            } else {
                result.completeExceptionally(baseError);
            }
        });
    }

    private CompletionStage<ClusterCompositionLookupResult> lookup(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        CompletionStage<ClusterCompositionLookupResult> compositionStage = routingTable.preferInitialRouter() ? this.lookupOnInitialRouterThenOnKnownRouters(securityPlan, routingTable, connectionProviderGetter, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError) : this.lookupOnKnownRoutersThenOnInitialRouter(securityPlan, routingTable, connectionProviderGetter, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError);
        return compositionStage;
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnKnownRoutersThenOnInitialRouter(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        HashSet<BoltServerAddress> seenServers = new HashSet<BoltServerAddress>();
        return this.lookupOnKnownRouters(securityPlan, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError).thenCompose(compositionLookupResult -> {
            if (compositionLookupResult != null) {
                return CompletableFuture.completedFuture(compositionLookupResult);
            }
            return this.lookupOnInitialRouter(securityPlan, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError);
        });
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnInitialRouterThenOnKnownRouters(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        Set<BoltServerAddress> seenServers = Collections.emptySet();
        return this.lookupOnInitialRouter(securityPlan, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError).thenCompose(compositionLookupResult -> {
            if (compositionLookupResult != null) {
                return CompletableFuture.completedFuture(compositionLookupResult);
            }
            return this.lookupOnKnownRouters(securityPlan, routingTable, connectionProviderGetter, new HashSet<BoltServerAddress>(), bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError);
        });
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnKnownRouters(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<BoltServerAddress> seenServers, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        for (BoltServerAddress address : routingTable.routers()) {
            result = result.thenCompose(composition -> {
                if (composition != null) {
                    return CompletableFuture.completedFuture(composition);
                }
                return this.lookupOnRouter(securityPlan, address, true, routingTable, connectionProviderGetter, seenServers, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError);
            });
        }
        return result.thenApply(composition -> composition != null ? new ClusterCompositionLookupResult((ClusterComposition)composition) : null);
    }

    private CompletionStage<ClusterCompositionLookupResult> lookupOnInitialRouter(SecurityPlan securityPlan, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<BoltServerAddress> seenServers, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        List<BoltServerAddress> resolvedRouters;
        try {
            resolvedRouters = this.resolve();
        }
        catch (Throwable error) {
            return CompletableFuture.failedFuture(error);
        }
        HashSet<BoltServerAddress> resolvedRouterSet = new HashSet<BoltServerAddress>(resolvedRouters);
        resolvedRouters.removeAll(seenServers);
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        for (BoltServerAddress address : resolvedRouters) {
            result = result.thenCompose(composition -> {
                if (composition != null) {
                    return CompletableFuture.completedFuture(composition);
                }
                return this.lookupOnRouter(securityPlan, address, false, routingTable, connectionProviderGetter, null, bookmarks, impersonatedUser, authMapStageSupplier, minVersion, baseError);
            });
        }
        return result.thenApply(composition -> composition != null ? new ClusterCompositionLookupResult((ClusterComposition)composition, (Set<BoltServerAddress>)resolvedRouterSet) : null);
    }

    private CompletionStage<ClusterComposition> lookupOnRouter(SecurityPlan securityPlan, BoltServerAddress routerAddress, boolean resolveAddress, RoutingTable routingTable, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Set<BoltServerAddress> seenServers, Set<String> bookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion, Throwable baseError) {
        CompletableFuture<BoltServerAddress> addressFuture = CompletableFuture.completedFuture(routerAddress);
        CompletableFuture<ClusterComposition> future = new CompletableFuture<ClusterComposition>();
        final CompletableFuture compositionFuture = new CompletableFuture();
        AtomicReference connectionRef = new AtomicReference();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)addressFuture.thenApply(address -> resolveAddress ? this.resolveByDomainNameOrThrowCompletionException((BoltServerAddress)address, routingTable) : address)).thenApply(address -> this.addAndReturn(seenServers, address))).thenCompose(address -> ((BoltConnectionProvider)connectionProviderGetter.apply((BoltServerAddress)address)).connect(securityPlan, null, authMapStageSupplier, AccessMode.READ, bookmarks, null, minVersion, null, ignored -> {}))).thenApply(connection -> {
            connectionRef.set(connection);
            return connection;
        })).thenCompose(connection -> connection.route(routingTable.database(), impersonatedUser, bookmarks))).thenCompose(connection -> connection.flush(new ResponseHandler(){
            ClusterComposition clusterComposition;
            Throwable throwable;

            @Override
            public void onError(Throwable throwable) {
                this.throwable = throwable;
            }

            @Override
            public void onRouteSummary(RouteSummary summary) {
                this.clusterComposition = summary.clusterComposition();
            }

            @Override
            public void onComplete() {
                if (this.throwable != null) {
                    compositionFuture.completeExceptionally(this.throwable);
                } else {
                    compositionFuture.complete(this.clusterComposition);
                }
            }
        }))).thenCompose(ignored -> compositionFuture)).thenApply(clusterComposition -> {
            if (clusterComposition.routers().isEmpty() || clusterComposition.readers().isEmpty()) {
                throw new CompletionException(new ProtocolException("Failed to parse result received from server due to no router or reader found in response."));
            }
            return clusterComposition;
        })).whenComplete((clusterComposition, throwable) -> {
            BoltConnection connection = (BoltConnection)connectionRef.get();
            CompletionStage<Void> connectionCloseStage = connection != null ? connection.close() : CompletableFuture.completedStage(null);
            Throwable cause = FutureUtil.completionExceptionCause(throwable);
            if (cause != null) {
                connectionCloseStage.whenComplete((ignored1, ignored2) -> {
                    try {
                        ClusterComposition composition = this.handleRoutingProcedureError(FutureUtil.completionExceptionCause(throwable), routingTable, routerAddress, baseError);
                        future.complete(composition);
                    }
                    catch (Throwable abortError) {
                        future.completeExceptionally(abortError);
                    }
                });
            } else {
                connectionCloseStage.whenComplete((ignored1, ignored2) -> future.complete((ClusterComposition)clusterComposition));
            }
        });
        return future;
    }

    private ClusterComposition handleRoutingProcedureError(Throwable error, RoutingTable routingTable, BoltServerAddress routerAddress, Throwable baseError) {
        if (this.mustAbortDiscovery(error)) {
            throw new CompletionException(error);
        }
        DiscoveryException discoveryError = new DiscoveryException(String.format(RECOVERABLE_ROUTING_ERROR, routerAddress), error);
        FutureUtil.combineErrors(baseError, discoveryError);
        this.log.log(System.Logger.Level.WARNING, RECOVERABLE_DISCOVERY_ERROR_WITH_SERVER, routerAddress);
        this.log.log(System.Logger.Level.DEBUG, String.format(RECOVERABLE_DISCOVERY_ERROR_WITH_SERVER, routerAddress), (Throwable)discoveryError);
        routingTable.forget(routerAddress);
        return null;
    }

    private boolean mustAbortDiscovery(Throwable throwable) {
        boolean abort = false;
        if (!(throwable instanceof AuthorizationExpiredException) && throwable instanceof SecurityException) {
            abort = true;
        } else if (throwable instanceof FatalDiscoveryException) {
            abort = true;
        } else if (throwable instanceof IllegalStateException && "Connection provider is closed.".equals(throwable.getMessage())) {
            abort = true;
        } else if (throwable instanceof AuthTokenManagerExecutionException) {
            abort = true;
        } else if (throwable instanceof UnsupportedFeatureException) {
            abort = true;
        } else if (throwable instanceof ClientException) {
            String code;
            abort = switch (code = ((ClientException)throwable).code()) {
                case TRANSACTION_INVALID_BOOKMARK_CODE, TRANSACTION_INVALID_BOOKMARK_MIXTURE_CODE, STATEMENT_ARGUMENT_ERROR_CODE, REQUEST_INVALID_CODE, STATEMENT_TYPE_ERROR_CODE -> true;
                default -> false;
            };
        } else if (throwable instanceof MinVersionAcquisitionException) {
            abort = true;
        }
        return abort;
    }

    @Override
    public List<BoltServerAddress> resolve() throws UnknownHostException {
        LinkedList<BoltServerAddress> resolvedAddresses = new LinkedList<BoltServerAddress>();
        UnknownHostException exception = null;
        for (BoltServerAddress serverAddress : this.resolver.apply(this.initialRouter)) {
            try {
                this.resolveAllByDomainName(serverAddress).unicastStream().forEach(resolvedAddresses::add);
            }
            catch (UnknownHostException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (resolvedAddresses.isEmpty() && exception != null) {
            throw exception;
        }
        return resolvedAddresses;
    }

    private <T> T addAndReturn(Collection<T> collection, T element) {
        if (collection != null) {
            collection.add(element);
        }
        return element;
    }

    private BoltServerAddress resolveByDomainNameOrThrowCompletionException(BoltServerAddress address, RoutingTable routingTable) {
        try {
            ResolvedBoltServerAddress resolvedAddress = this.resolveAllByDomainName(address);
            routingTable.replaceRouterIfPresent(address, resolvedAddress);
            return resolvedAddress.unicastStream().findFirst().orElseThrow(() -> new IllegalStateException("Unexpected condition, the ResolvedBoltServerAddress must always have at least one unicast address"));
        }
        catch (Throwable e) {
            throw new CompletionException(e);
        }
    }

    private ResolvedBoltServerAddress resolveAllByDomainName(BoltServerAddress address) throws UnknownHostException {
        return new ResolvedBoltServerAddress(address.host(), address.port(), this.domainNameResolver.resolve(address.host()));
    }
}

