/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.HandshakeHandler;
import org.neo4j.driver.internal.bolt.basicimpl.logging.ChannelActivityLogger;

public class ChannelConnectedListener
implements ChannelFutureListener {
    private final BoltServerAddress address;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final CompletableFuture<Channel> handshakeCompletedFuture;
    private final LoggingProvider logging;

    public ChannelConnectedListener(BoltServerAddress address, ChannelPipelineBuilder pipelineBuilder, CompletableFuture<Channel> handshakeCompletedFuture, LoggingProvider logging) {
        this.address = address;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedFuture = handshakeCompletedFuture;
        this.logging = logging;
    }

    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            Channel channel = future.channel();
            ChannelActivityLogger log = new ChannelActivityLogger(channel, this.logging, this.getClass());
            log.log(System.Logger.Level.TRACE, "Channel %s connected, initiating bolt handshake", channel);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HandshakeHandler(this.pipelineBuilder, this.handshakeCompletedFuture, this.logging)});
            log.log(System.Logger.Level.DEBUG, "C: [Bolt Handshake] %s", BoltProtocolUtil.handshakeString());
            channel.writeAndFlush((Object)BoltProtocolUtil.handshakeBuf()).addListener(f -> {
                if (!f.isSuccess()) {
                    Throwable error = f.cause();
                    error = error instanceof SSLHandshakeException ? new SecurityException("Failed to establish secured connection with the server", error) : new ServiceUnavailableException(String.format("Unable to write Bolt handshake to %s.", this.address), error);
                    this.handshakeCompletedFuture.completeExceptionally(error);
                }
            });
        } else {
            this.handshakeCompletedFuture.completeExceptionally(ChannelConnectedListener.databaseUnavailableError(this.address, future.cause()));
        }
    }

    private static Throwable databaseUnavailableError(BoltServerAddress address, Throwable cause) {
        return new ServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", address), cause);
    }
}

