/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.ClientCertificate;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;

public class ValidatingClientCertificateManager
implements ClientCertificateManager {
    private final ClientCertificateManager delegate;

    public ValidatingClientCertificateManager(ClientCertificateManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletionStage<ClientCertificate> getClientCertificate() {
        CompletionStage<ClientCertificate> certificateStage;
        try {
            certificateStage = this.delegate.getClientCertificate();
        }
        catch (Throwable throwable) {
            String message = "An exception has been thrown by the ClientCertificateManager.";
            return CompletableFuture.failedFuture(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, throwable));
        }
        return certificateStage;
    }
}

