/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.summary.GqlStatusObject;

public class InternalGqlStatusObject
implements GqlStatusObject {
    public static final GqlStatusObject SUCCESS = new InternalGqlStatusObject("00000", "note: successful completion", Map.ofEntries(Map.entry("CURRENT_SCHEMA", Values.value("/")), Map.entry("OPERATION", Values.value("")), Map.entry("OPERATION_CODE", Values.value("0"))));
    public static final GqlStatusObject NO_DATA = new InternalGqlStatusObject("02000", "note: no data", Map.ofEntries(Map.entry("CURRENT_SCHEMA", Values.value("/")), Map.entry("OPERATION", Values.value("")), Map.entry("OPERATION_CODE", Values.value("0"))));
    public static final GqlStatusObject NO_DATA_UNKNOWN = new InternalGqlStatusObject("02N42", "note: no data - unknown subcondition", Map.ofEntries(Map.entry("CURRENT_SCHEMA", Values.value("/")), Map.entry("OPERATION", Values.value("")), Map.entry("OPERATION_CODE", Values.value("0"))));
    public static final GqlStatusObject OMITTED_RESULT = new InternalGqlStatusObject("00001", "note: successful completion - omitted result", Map.ofEntries(Map.entry("CURRENT_SCHEMA", Values.value("/")), Map.entry("OPERATION", Values.value("")), Map.entry("OPERATION_CODE", Values.value("0"))));
    private final String gqlStatus;
    private final String statusDescription;
    private final Map<String, Value> diagnosticRecord;

    public InternalGqlStatusObject(String gqlStatus, String statusDescription, Map<String, Value> diagnosticRecord) {
        this.gqlStatus = Objects.requireNonNull(gqlStatus);
        this.statusDescription = Objects.requireNonNull(statusDescription);
        this.diagnosticRecord = Objects.requireNonNull(diagnosticRecord);
    }

    @Override
    public String gqlStatus() {
        return this.gqlStatus;
    }

    @Override
    public String statusDescription() {
        return this.statusDescription;
    }

    @Override
    public Map<String, Value> diagnosticRecord() {
        return this.diagnosticRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalGqlStatusObject that = (InternalGqlStatusObject)o;
        return Objects.equals(this.gqlStatus, that.gqlStatus) && Objects.equals(this.statusDescription, that.statusDescription) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord);
    }

    public int hashCode() {
        return Objects.hash(this.gqlStatus, this.statusDescription, this.diagnosticRecord);
    }

    public String toString() {
        return "InternalGqlStatusObject{gqlStatus='" + this.gqlStatus + "', statusDescription='" + this.statusDescription + "', diagnosticRecord=" + this.diagnosticRecord + "}";
    }
}

