/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.HashMap;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.SingleDatabaseRoutingProcedureRunner;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.spi.Connection;

public class MultiDatabasesRoutingProcedureRunner
extends SingleDatabaseRoutingProcedureRunner {
    static final String DATABASE_NAME = "database";
    static final String MULTI_DB_GET_ROUTING_TABLE = String.format("CALL dbms.routing.getRoutingTable($%s, $%s)", "context", "database");

    public MultiDatabasesRoutingProcedureRunner(RoutingContext context, Logging logging) {
        super(context, logging);
    }

    @Override
    Set<Bookmark> adaptBookmarks(Set<Bookmark> bookmarks) {
        return bookmarks;
    }

    @Override
    Query procedureQuery(BoltProtocolVersion protocolVersion, DatabaseName databaseName) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("context", Values.value(this.context.toMap()));
        map.put(DATABASE_NAME, Values.value(databaseName.databaseName().orElse(null)));
        return new Query(MULTI_DB_GET_ROUTING_TABLE, Values.value(map));
    }

    @Override
    DirectConnection connection(Connection connection) {
        return new DirectConnection(connection, DatabaseNameUtil.systemDatabase(), AccessMode.READ, null);
    }
}

