/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.spi.Connection;

public class ImpersonationUtil {
    public static final String IMPERSONATION_UNSUPPORTED_ERROR_MESSAGE = "Detected connection that does not support impersonation, please make sure to have all servers running 4.4 version or above and communicating over Bolt version 4.4 or above when using impersonation feature";

    public static Connection ensureImpersonationSupport(Connection connection, String impersonatedUser) {
        if (impersonatedUser != null && !ImpersonationUtil.supportsImpersonation(connection)) {
            throw new ClientException(IMPERSONATION_UNSUPPORTED_ERROR_MESSAGE);
        }
        return connection;
    }

    private static boolean supportsImpersonation(Connection connection) {
        return connection.protocol().version().compareTo(BoltProtocolV44.VERSION) >= 0;
    }
}

