/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public abstract class AbstractReactiveSession<S> {
    protected final NetworkSession session;

    public AbstractReactiveSession(NetworkSession session) {
        this.session = session;
    }

    protected abstract S createTransaction(UnmanagedTransaction var1);

    protected abstract Publisher<Void> closeTransaction(S var1, boolean var2);

    Publisher<S> doBeginTransaction(TransactionConfig config) {
        return this.doBeginTransaction(config, null);
    }

    protected Publisher<S> doBeginTransaction(TransactionConfig config, String txType) {
        return RxUtils.createSingleItemPublisher(() -> {
            CompletableFuture txFuture = new CompletableFuture();
            this.session.beginTransactionAsync(config, txType).whenComplete((tx, completionError) -> {
                if (tx != null) {
                    txFuture.complete(this.createTransaction((UnmanagedTransaction)tx));
                } else {
                    this.releaseConnectionBeforeReturning(txFuture, (Throwable)completionError);
                }
            });
            return txFuture;
        }, () -> new IllegalStateException("Unexpected condition, begin transaction call has completed successfully with transaction being null"));
    }

    Publisher<S> beginTransaction(AccessMode mode, TransactionConfig config) {
        return RxUtils.createSingleItemPublisher(() -> {
            CompletableFuture txFuture = new CompletableFuture();
            this.session.beginTransactionAsync(mode, config).whenComplete((tx, completionError) -> {
                if (tx != null) {
                    txFuture.complete(this.createTransaction((UnmanagedTransaction)tx));
                } else {
                    this.releaseConnectionBeforeReturning(txFuture, (Throwable)completionError);
                }
            });
            return txFuture;
        }, () -> new IllegalStateException("Unexpected condition, begin transaction call has completed successfully with transaction being null"));
    }

    protected <T> Publisher<T> runTransaction(AccessMode mode, Function<S, ? extends Publisher<T>> work, TransactionConfig config) {
        Flux repeatableWork = Flux.usingWhen(this.beginTransaction(mode, config), work, tx -> this.closeTransaction(tx, true), (tx, error) -> this.closeTransaction(tx, false), tx -> this.closeTransaction(tx, false));
        return this.session.retryLogic().retryRx(repeatableWork);
    }

    private <T> void releaseConnectionBeforeReturning(CompletableFuture<T> returnFuture, Throwable completionError) {
        Throwable error = Futures.completionExceptionCause(completionError);
        if (error instanceof TransactionNestingException) {
            returnFuture.completeExceptionally(error);
        } else {
            this.session.releaseConnectionAsync().whenComplete((ignored, closeError) -> returnFuture.completeExceptionally(Futures.combineErrors(error, closeError)));
        }
    }

    public Set<Bookmark> lastBookmarks() {
        return this.session.lastBookmarks();
    }

    protected <T> Publisher<T> doClose() {
        return RxUtils.createEmptyPublisher(this.session::closeAsync);
    }
}

