/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v5;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.messaging.common.CommonValueUnpacker;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class ValueUnpackerV5
extends CommonValueUnpacker {
    private static final int NODE_FIELDS = 4;
    private static final int RELATIONSHIP_FIELDS = 8;

    public ValueUnpackerV5(PackInput input) {
        super(input, true);
    }

    @Override
    protected int getNodeFields() {
        return 4;
    }

    @Override
    protected int getRelationshipFields() {
        return 8;
    }

    @Override
    protected InternalNode unpackNode() throws IOException {
        long urn = this.unpacker.unpackLong();
        int numLabels = (int)this.unpacker.unpackListHeader();
        ArrayList<String> labels = new ArrayList<String>(numLabels);
        for (int i = 0; i < numLabels; ++i) {
            labels.add(this.unpacker.unpackString());
        }
        int numProps = (int)this.unpacker.unpackMapHeader();
        HashMap<String, Value> props = Iterables.newHashMapWithSize(numProps);
        for (int j = 0; j < numProps; ++j) {
            String key = this.unpacker.unpackString();
            props.put(key, this.unpack());
        }
        String elementId = this.unpacker.unpackString();
        return new InternalNode(urn, elementId, labels, props);
    }

    @Override
    protected Value unpackPath() throws IOException {
        InternalNode[] uniqNodes = new InternalNode[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqNodes.length; ++i) {
            this.ensureCorrectStructSize(TypeConstructor.NODE, this.getNodeFields(), this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("NODE", (byte)78, this.unpacker.unpackStructSignature());
            uniqNodes[i] = this.unpackNode();
        }
        InternalRelationship[] uniqRels = new InternalRelationship[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqRels.length; ++i) {
            this.ensureCorrectStructSize(TypeConstructor.RELATIONSHIP, 4, this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("UNBOUND_RELATIONSHIP", (byte)114, this.unpacker.unpackStructSignature());
            long id = this.unpacker.unpackLong();
            String relType = this.unpacker.unpackString();
            Map<String, Value> props = this.unpackMap();
            String elementId = this.unpacker.unpackString();
            uniqRels[i] = new InternalRelationship(id, elementId, -1L, String.valueOf(-1), -1L, String.valueOf(-1), relType, props);
        }
        int length = (int)this.unpacker.unpackListHeader();
        Path.Segment[] segments = new Path.Segment[length / 2];
        Node[] nodes = new Node[segments.length + 1];
        Relationship[] rels = new Relationship[segments.length];
        InternalNode prevNode = uniqNodes[0];
        nodes[0] = prevNode;
        for (int i = 0; i < segments.length; ++i) {
            InternalRelationship rel;
            int relIdx = (int)this.unpacker.unpackLong();
            InternalNode nextNode = uniqNodes[(int)this.unpacker.unpackLong()];
            if (relIdx < 0) {
                rel = uniqRels[-relIdx - 1];
                this.setStartAndEnd(rel, nextNode, prevNode);
            } else {
                rel = uniqRels[relIdx - 1];
                this.setStartAndEnd(rel, prevNode, nextNode);
            }
            nodes[i + 1] = nextNode;
            rels[i] = rel;
            segments[i] = new InternalPath.SelfContainedSegment(prevNode, rel, nextNode);
            prevNode = nextNode;
        }
        return new PathValue(new InternalPath(Arrays.asList(segments), Arrays.asList(nodes), Arrays.asList(rels)));
    }

    private void setStartAndEnd(InternalRelationship rel, InternalNode start, InternalNode end) {
        rel.setStartAndEnd(start.id(), start.elementId(), end.id(), end.elementId());
    }

    @Override
    protected Value unpackRelationship() throws IOException {
        long urn = this.unpacker.unpackLong();
        long startUrn = this.unpacker.unpackLong();
        long endUrn = this.unpacker.unpackLong();
        String relType = this.unpacker.unpackString();
        Map<String, Value> props = this.unpackMap();
        String elementId = this.unpacker.unpackString();
        String startElementId = this.unpacker.unpackString();
        String endElementId = this.unpacker.unpackString();
        InternalRelationship adapted = new InternalRelationship(urn, elementId, startUrn, startElementId, endUrn, endElementId, relType, props);
        return new RelationshipValue(adapted);
    }
}

