/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.handlers.RoutingResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;

public class RoutingConnection
implements Connection {
    private final Connection delegate;
    private final AccessMode accessMode;
    private final RoutingErrorHandler errorHandler;
    private final DatabaseName databaseName;
    private final String impersonatedUser;

    public RoutingConnection(Connection delegate, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, RoutingErrorHandler errorHandler) {
        this.delegate = delegate;
        this.databaseName = databaseName;
        this.accessMode = accessMode;
        this.impersonatedUser = impersonatedUser;
        this.errorHandler = errorHandler;
    }

    @Override
    public void enableAutoRead() {
        this.delegate.enableAutoRead();
    }

    @Override
    public void disableAutoRead() {
        this.delegate.disableAutoRead();
    }

    @Override
    public void write(Message message, ResponseHandler handler) {
        this.delegate.write(message, this.newRoutingResponseHandler(handler));
    }

    @Override
    public void writeAndFlush(Message message, ResponseHandler handler) {
        this.delegate.writeAndFlush(message, this.newRoutingResponseHandler(handler));
    }

    @Override
    public CompletionStage<Void> reset(Throwable throwable) {
        return this.delegate.reset(throwable);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public CompletionStage<Void> release() {
        return this.delegate.release();
    }

    @Override
    public void terminateAndRelease(String reason) {
        this.delegate.terminateAndRelease(reason);
    }

    @Override
    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    @Override
    public BoltProtocol protocol() {
        return this.delegate.protocol();
    }

    @Override
    public void bindTerminationAwareStateLockingExecutor(TerminationAwareStateLockingExecutor executor) {
        this.delegate.bindTerminationAwareStateLockingExecutor(executor);
    }

    @Override
    public AccessMode mode() {
        return this.accessMode;
    }

    @Override
    public DatabaseName databaseName() {
        return this.databaseName;
    }

    @Override
    public String impersonatedUser() {
        return this.impersonatedUser;
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.delegate.isTelemetryEnabled();
    }

    private RoutingResponseHandler newRoutingResponseHandler(ResponseHandler handler) {
        return new RoutingResponseHandler(handler, this.serverAddress(), this.accessMode, this.errorHandler);
    }
}

