/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.util.Futures;

public class ResultCursorsHolder {
    private final List<CompletionStage<? extends FailableCursor>> cursorStages = Collections.synchronizedList(new ArrayList());

    public void add(CompletionStage<? extends FailableCursor> cursorStage) {
        Objects.requireNonNull(cursorStage);
        this.cursorStages.add(cursorStage);
    }

    CompletionStage<Throwable> retrieveNotConsumedError() {
        CompletableFuture[] failures = this.retrieveAllFailures();
        return CompletableFuture.allOf(failures).thenApply(ignore -> ResultCursorsHolder.findFirstFailure(failures));
    }

    private CompletableFuture<Throwable>[] retrieveAllFailures() {
        return (CompletableFuture[])this.cursorStages.stream().map(ResultCursorsHolder::retrieveFailure).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
    }

    private static Throwable findFirstFailure(CompletableFuture<Throwable>[] completedFailureFutures) {
        return Arrays.stream(completedFailureFutures).map(failureFuture -> failureFuture.getNow(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static CompletionStage<Throwable> retrieveFailure(CompletionStage<? extends FailableCursor> cursorStage) {
        return cursorStage.exceptionally(cursor -> null).thenCompose(cursor -> cursor == null ? Futures.completedWithNull() : cursor.discardAllFailureAsync());
    }
}

