/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.time.Clock;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ConnectionReadTimeoutHandler;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.handlers.ChannelReleasingResetResponseHandler;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.LockUtil;

public class NetworkConnection
implements Connection {
    private final Logger log;
    private final Lock lock;
    private final Channel channel;
    private final InboundMessageDispatcher messageDispatcher;
    private final String serverAgent;
    private final BoltServerAddress serverAddress;
    private final boolean telemetryEnabled;
    private final BoltProtocol protocol;
    private final ExtendedChannelPool channelPool;
    private final CompletableFuture<Void> releaseFuture;
    private final Clock clock;
    private final MetricsListener metricsListener;
    private final ListenerEvent<?> inUseEvent;
    private final Long connectionReadTimeout;
    private Status status = Status.OPEN;
    private TerminationAwareStateLockingExecutor terminationAwareStateLockingExecutor;
    private ChannelHandler connectionReadTimeoutHandler;

    public NetworkConnection(Channel channel, ExtendedChannelPool channelPool, Clock clock, MetricsListener metricsListener, Logging logging) {
        this.log = logging.getLog(this.getClass());
        this.lock = new ReentrantLock();
        this.channel = channel;
        this.messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        this.serverAgent = ChannelAttributes.serverAgent(channel);
        this.serverAddress = ChannelAttributes.serverAddress(channel);
        this.telemetryEnabled = ChannelAttributes.telemetryEnabled(channel);
        this.protocol = BoltProtocol.forChannel(channel);
        this.channelPool = channelPool;
        this.releaseFuture = new CompletableFuture();
        this.clock = clock;
        this.metricsListener = metricsListener;
        this.inUseEvent = metricsListener.createListenerEvent();
        this.connectionReadTimeout = ChannelAttributes.connectionReadTimeout(channel).orElse(null);
        metricsListener.afterConnectionCreated(ChannelAttributes.poolId(this.channel), this.inUseEvent);
    }

    @Override
    public boolean isOpen() {
        return LockUtil.executeWithLock(this.lock, () -> this.status == Status.OPEN);
    }

    @Override
    public void enableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(true);
        }
    }

    @Override
    public void disableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(false);
        }
    }

    @Override
    public void write(Message message, ResponseHandler handler) {
        if (this.verifyOpen(handler)) {
            this.writeMessageInEventLoop(message, handler, false);
        }
    }

    @Override
    public void writeAndFlush(Message message, ResponseHandler handler) {
        if (this.verifyOpen(handler)) {
            this.writeMessageInEventLoop(message, handler, true);
        }
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    @Override
    public CompletionStage<Void> reset(Throwable throwable) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ResetResponseHandler handler = new ResetResponseHandler(this.messageDispatcher, result, throwable);
        this.writeResetMessageIfNeeded(handler, true);
        return result;
    }

    @Override
    public CompletionStage<Void> release() {
        if (LockUtil.executeWithLock(this.lock, () -> this.updateStateIfOpen(Status.RELEASED)).booleanValue()) {
            ChannelReleasingResetResponseHandler handler = new ChannelReleasingResetResponseHandler(this.channel, this.channelPool, this.messageDispatcher, this.clock, this.releaseFuture);
            this.writeResetMessageIfNeeded(handler, false);
            this.metricsListener.afterConnectionReleased(ChannelAttributes.poolId(this.channel), this.inUseEvent);
        }
        return this.releaseFuture;
    }

    @Override
    public void terminateAndRelease(String reason) {
        if (LockUtil.executeWithLock(this.lock, () -> this.updateStateIfOpen(Status.TERMINATED)).booleanValue()) {
            ChannelAttributes.setTerminationReason(this.channel, reason);
            Futures.asCompletionStage(this.channel.close()).exceptionally(throwable -> null).thenCompose(ignored -> this.channelPool.release(this.channel)).whenComplete((ignored, throwable) -> {
                this.releaseFuture.complete(null);
                this.metricsListener.afterConnectionReleased(ChannelAttributes.poolId(this.channel), this.inUseEvent);
            });
        }
    }

    @Override
    public String serverAgent() {
        return this.serverAgent;
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    @Override
    public BoltProtocol protocol() {
        return this.protocol;
    }

    @Override
    public void bindTerminationAwareStateLockingExecutor(TerminationAwareStateLockingExecutor executor) {
        LockUtil.executeWithLock(this.lock, () -> {
            if (this.terminationAwareStateLockingExecutor != null) {
                throw new IllegalStateException("terminationAwareStateLockingExecutor is already set");
            }
            this.terminationAwareStateLockingExecutor = executor;
        });
    }

    private boolean updateStateIfOpen(Status newStatus) {
        if (Status.OPEN.equals((Object)this.status)) {
            this.status = newStatus;
            return true;
        }
        return false;
    }

    private void writeResetMessageIfNeeded(ResponseHandler resetHandler, boolean isSessionReset) {
        this.channel.eventLoop().execute(() -> {
            if (isSessionReset && !this.isOpen()) {
                resetHandler.onSuccess(Collections.emptyMap());
            } else {
                this.setAutoRead(true);
                this.messageDispatcher.enqueue(resetHandler);
                this.channel.writeAndFlush((Object)ResetMessage.RESET).addListener(future -> this.registerConnectionReadTimeout(this.channel));
            }
        });
    }

    private void writeMessageInEventLoop(Message message, ResponseHandler handler, boolean flush) {
        this.channel.eventLoop().execute(() -> this.terminationAwareStateLockingExecutor(message).execute(causeOfTermination -> {
            if (causeOfTermination == null) {
                this.messageDispatcher.enqueue(handler);
                if (flush) {
                    this.channel.writeAndFlush((Object)message).addListener(future -> this.registerConnectionReadTimeout(this.channel));
                } else {
                    this.channel.write((Object)message, this.channel.voidPromise());
                }
            } else {
                handler.onFailure((Throwable)causeOfTermination);
            }
        }));
    }

    private void setAutoRead(boolean value) {
        this.channel.config().setAutoRead(value);
    }

    private boolean verifyOpen(ResponseHandler handler) {
        Status connectionStatus = LockUtil.executeWithLock(this.lock, () -> this.status);
        return switch (connectionStatus) {
            default -> throw new IncompatibleClassChangeError();
            case Status.OPEN -> true;
            case Status.RELEASED -> {
                IllegalStateException error = new IllegalStateException("Connection has been released to the pool and can't be used");
                if (handler != null) {
                    handler.onFailure(error);
                }
                yield false;
            }
            case Status.TERMINATED -> {
                IllegalStateException terminatedError = new IllegalStateException("Connection has been terminated and can't be used");
                if (handler != null) {
                    handler.onFailure(terminatedError);
                }
                yield false;
            }
        };
    }

    private void registerConnectionReadTimeout(Channel channel) {
        if (!channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        if (this.connectionReadTimeout != null && this.connectionReadTimeoutHandler == null) {
            this.connectionReadTimeoutHandler = new ConnectionReadTimeoutHandler(this.connectionReadTimeout, TimeUnit.SECONDS);
            channel.pipeline().addFirst(new ChannelHandler[]{this.connectionReadTimeoutHandler});
            this.log.debug("Added ConnectionReadTimeoutHandler", new Object[0]);
            this.messageDispatcher.setBeforeLastHandlerHook(messageType -> {
                channel.pipeline().remove(this.connectionReadTimeoutHandler);
                this.connectionReadTimeoutHandler = null;
                this.messageDispatcher.setBeforeLastHandlerHook(null);
                this.log.debug("Removed ConnectionReadTimeoutHandler", new Object[0]);
            });
        }
    }

    private TerminationAwareStateLockingExecutor terminationAwareStateLockingExecutor(Message message) {
        TerminationAwareStateLockingExecutor lockingExecutor;
        TerminationAwareStateLockingExecutor result = consumer -> consumer.accept(null);
        if (this.isQueryMessage(message) && (lockingExecutor = LockUtil.executeWithLock(this.lock, () -> this.terminationAwareStateLockingExecutor)) != null) {
            result = lockingExecutor;
        }
        return result;
    }

    private boolean isQueryMessage(Message message) {
        return message instanceof RunWithMetadataMessage || message instanceof PullMessage || message instanceof PullAllMessage || message instanceof DiscardMessage || message instanceof DiscardAllMessage || message instanceof CommitMessage || message instanceof RollbackMessage;
    }

    private static enum Status {
        OPEN,
        RELEASED,
        TERMINATED;

    }
}

