/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.spi.ResponseHandler;

public class LogonResponseHandler
implements ResponseHandler {
    private final CompletableFuture<?> future;
    private final Channel channel;
    private final Clock clock;

    public LogonResponseHandler(CompletableFuture<?> future, Channel channel, Clock clock) {
        this.future = Objects.requireNonNull(future, "future must not be null");
        this.channel = Objects.requireNonNull(channel, "channel must not be null");
        this.clock = Objects.requireNonNull(clock, "clock must not be null");
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        ChannelAttributes.authContext(this.channel).finishAuth(this.clock.millis());
        this.future.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.future.completeExceptionally(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        this.future.completeExceptionally(new ProtocolException("Records are not supported on LOGON"));
    }
}

