/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.spi.ResponseHandler;

public class LogoffResponseHandler
implements ResponseHandler {
    private final CompletableFuture<?> future;

    public LogoffResponseHandler(CompletableFuture<?> future) {
        this.future = Objects.requireNonNull(future, "future must not be null");
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.future.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.future.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.future.completeExceptionally(new ProtocolException("Records are not supported on LOGON"));
    }
}

