/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.messaging.v5.BoltProtocolV5;
import org.neo4j.driver.internal.messaging.v54.BoltProtocolV54;

public final class BoltProtocolUtil {
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    public static final BoltProtocolVersion NO_PROTOCOL_VERSION = new BoltProtocolVersion(0, 0);
    public static final int CHUNK_HEADER_SIZE_BYTES = 2;
    public static final int DEFAULT_MAX_OUTBOUND_CHUNK_SIZE_BYTES = 16383;
    private static final ByteBuf HANDSHAKE_BUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copyInt((int[])new int[]{1616949271, BoltProtocolV54.VERSION.toIntRange(BoltProtocolV5.VERSION), BoltProtocolV44.VERSION.toIntRange(BoltProtocolV42.VERSION), BoltProtocolV41.VERSION.toInt(), BoltProtocolV3.VERSION.toInt()})).asReadOnly();
    private static final String HANDSHAKE_STRING = BoltProtocolUtil.createHandshakeString();

    private BoltProtocolUtil() {
    }

    public static ByteBuf handshakeBuf() {
        return HANDSHAKE_BUF.duplicate();
    }

    public static String handshakeString() {
        return HANDSHAKE_STRING;
    }

    public static void writeMessageBoundary(ByteBuf buf) {
        buf.writeShort(0);
    }

    public static void writeEmptyChunkHeader(ByteBuf buf) {
        buf.writeShort(0);
    }

    public static void writeChunkHeader(ByteBuf buf, int chunkStartIndex, int headerValue) {
        buf.setShort(chunkStartIndex, headerValue);
    }

    private static String createHandshakeString() {
        ByteBuf buf = BoltProtocolUtil.handshakeBuf();
        return String.format("[0x%s, %s, %s, %s, %s]", Integer.toHexString(buf.readInt()), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }
}

