/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.net.URI;
import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.driver.internal.security.ValidatingAuthTokenManager;

public final class GraphDatabase {
    private GraphDatabase() {
    }

    public static Driver driver(String uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri, Config config) {
        return GraphDatabase.driver(uri, AuthTokens.none(), config);
    }

    public static Driver driver(String uri, Config config) {
        return GraphDatabase.driver(URI.create(uri), config);
    }

    public static Driver driver(String uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthToken authToken, Config config) {
        return GraphDatabase.driver(URI.create(uri), authToken, config);
    }

    public static Driver driver(URI uri, AuthToken authToken, Config config) {
        if (authToken == null) {
            authToken = AuthTokens.none();
        }
        return GraphDatabase.driver(uri, authToken, config, new DriverFactory());
    }

    public static Driver driver(URI uri, AuthTokenManager authTokenManager) {
        return GraphDatabase.driver(uri, authTokenManager, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthTokenManager authTokenManager) {
        return GraphDatabase.driver(URI.create(uri), authTokenManager);
    }

    public static Driver driver(URI uri, AuthTokenManager authTokenManager, Config config) {
        return GraphDatabase.driver(uri, authTokenManager, config, new DriverFactory());
    }

    public static Driver driver(String uri, AuthTokenManager authTokenManager, Config config) {
        return GraphDatabase.driver(URI.create(uri), authTokenManager, config);
    }

    private static Driver driver(URI uri, AuthToken authToken, Config config, DriverFactory driverFactory) {
        config = GraphDatabase.getOrDefault(config);
        return driverFactory.newInstance(uri, new StaticAuthTokenManager(authToken), config);
    }

    private static Driver driver(URI uri, AuthTokenManager authTokenManager, Config config, DriverFactory driverFactory) {
        Objects.requireNonNull(authTokenManager, "authTokenManager must not be null");
        config = GraphDatabase.getOrDefault(config);
        return driverFactory.newInstance(uri, new ValidatingAuthTokenManager(authTokenManager, config.logging()), config);
    }

    private static Config getOrDefault(Config config) {
        return config != null ? config : Config.defaultConfig();
    }
}

