/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.summary.ProfiledPlan;

public class InternalProfiledPlan
extends InternalPlan<ProfiledPlan>
implements ProfiledPlan {
    private final long dbHits;
    private final long records;
    private final long pageCacheHits;
    private final long pageCacheMisses;
    private final double pageCacheHitRatio;
    private final long time;
    public static final InternalPlan.PlanCreator<ProfiledPlan> PROFILED_PLAN = (operatorType, arguments, identifiers, children, originalPlanValue) -> new InternalProfiledPlan(operatorType, arguments, identifiers, children, originalPlanValue.get("dbHits").asLong(0L), originalPlanValue.get("rows").asLong(0L), originalPlanValue.get("pageCacheHits").asLong(0L), originalPlanValue.get("pageCacheMisses").asLong(0L), originalPlanValue.get("pageCacheHitRatio").asDouble(0.0), originalPlanValue.get("time").asLong(0L));
    public static final Function<Value, ProfiledPlan> PROFILED_PLAN_FROM_VALUE = new InternalPlan.Converter<ProfiledPlan>(PROFILED_PLAN);

    protected InternalProfiledPlan(String operatorType, Map<String, Value> arguments, List<String> identifiers, List<ProfiledPlan> children, long dbHits, long records, long pageCacheHits, long pageCacheMisses, double pageCacheHitRatio, long time) {
        super(operatorType, arguments, identifiers, children);
        this.dbHits = dbHits;
        this.records = records;
        this.pageCacheHits = pageCacheHits;
        this.pageCacheMisses = pageCacheMisses;
        this.pageCacheHitRatio = pageCacheHitRatio;
        this.time = time;
    }

    @Override
    public long dbHits() {
        return this.dbHits;
    }

    @Override
    public long records() {
        return this.records;
    }

    @Override
    public boolean hasPageCacheStats() {
        return this.pageCacheHits > 0L || this.pageCacheMisses > 0L || this.pageCacheHitRatio > 0.0;
    }

    @Override
    public long pageCacheHits() {
        return this.pageCacheHits;
    }

    @Override
    public long pageCacheMisses() {
        return this.pageCacheMisses;
    }

    @Override
    public double pageCacheHitRatio() {
        return this.pageCacheHitRatio;
    }

    @Override
    public long time() {
        return this.time;
    }
}

