/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarksSupplier;

public final class BookmarkManagerConfig {
    private final Map<String, Set<Bookmark>> initialBookmarks;
    private final BiConsumer<String, Set<Bookmark>> bookmarksConsumer;
    private final BookmarksSupplier bookmarksSupplier;

    private BookmarkManagerConfig(BookmarkManagerConfigBuilder builder) {
        this.initialBookmarks = builder.initialBookmarks;
        this.bookmarksConsumer = builder.bookmarksConsumer;
        this.bookmarksSupplier = builder.bookmarksSupplier;
    }

    public static BookmarkManagerConfigBuilder builder() {
        return new BookmarkManagerConfigBuilder();
    }

    public Map<String, Set<Bookmark>> initialBookmarks() {
        return this.initialBookmarks;
    }

    public Optional<BiConsumer<String, Set<Bookmark>>> bookmarksConsumer() {
        return Optional.ofNullable(this.bookmarksConsumer);
    }

    public Optional<BookmarksSupplier> bookmarksSupplier() {
        return Optional.ofNullable(this.bookmarksSupplier);
    }

    public static final class BookmarkManagerConfigBuilder {
        private Map<String, Set<Bookmark>> initialBookmarks = Collections.emptyMap();
        private BiConsumer<String, Set<Bookmark>> bookmarksConsumer;
        private BookmarksSupplier bookmarksSupplier;

        private BookmarkManagerConfigBuilder() {
        }

        public BookmarkManagerConfigBuilder withInitialBookmarks(Map<String, Set<Bookmark>> databaseToBookmarks) {
            Objects.requireNonNull(databaseToBookmarks, "databaseToBookmarks must not be null");
            this.initialBookmarks = databaseToBookmarks;
            return this;
        }

        public BookmarkManagerConfigBuilder withBookmarksConsumer(BiConsumer<String, Set<Bookmark>> bookmarksConsumer) {
            this.bookmarksConsumer = bookmarksConsumer;
            return this;
        }

        public BookmarkManagerConfigBuilder withBookmarksSupplier(BookmarksSupplier bookmarksSupplier) {
            this.bookmarksSupplier = bookmarksSupplier;
            return this;
        }

        public BookmarkManagerConfig build() {
            return new BookmarkManagerConfig(this);
        }
    }
}

