/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

abstract class AbstractReactiveTransaction {
    protected final UnmanagedTransaction tx;

    protected AbstractReactiveTransaction(UnmanagedTransaction tx) {
        this.tx = tx;
    }

    public <T> Publisher<T> commit() {
        return RxUtils.createEmptyPublisher(this.tx::commitAsync);
    }

    public <T> Publisher<T> rollback() {
        return RxUtils.createEmptyPublisher(this.tx::rollbackAsync);
    }

    public Publisher<Void> close() {
        return this.close(false);
    }

    public Publisher<Boolean> isOpen() {
        return Mono.just((Object)this.tx.isOpen());
    }

    Publisher<Void> close(boolean commit) {
        return RxUtils.createEmptyPublisher(() -> this.tx.closeAsync(commit));
    }
}

