/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.HandshakeHandler;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;

public class ChannelConnectedListener
implements ChannelFutureListener {
    private final BoltServerAddress address;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final ChannelPromise handshakeCompletedPromise;
    private final Logging logging;

    public ChannelConnectedListener(BoltServerAddress address, ChannelPipelineBuilder pipelineBuilder, ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.address = address;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedPromise = handshakeCompletedPromise;
        this.logging = logging;
    }

    public void operationComplete(ChannelFuture future) {
        Channel channel = future.channel();
        ChannelActivityLogger log = new ChannelActivityLogger(channel, this.logging, this.getClass());
        if (future.isSuccess()) {
            log.trace("Channel %s connected, initiating bolt handshake", channel);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HandshakeHandler(this.pipelineBuilder, this.handshakeCompletedPromise, this.logging)});
            log.debug("C: [Bolt Handshake] %s", BoltProtocolUtil.handshakeString());
            channel.writeAndFlush((Object)BoltProtocolUtil.handshakeBuf(), channel.voidPromise());
        } else {
            this.handshakeCompletedPromise.setFailure(ChannelConnectedListener.databaseUnavailableError(this.address, future.cause()));
        }
    }

    private static Throwable databaseUnavailableError(BoltServerAddress address, Throwable cause) {
        return new ServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", address), cause);
    }
}

