/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.AbstractReactiveTransaction;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxTransaction;

public class InternalRxTransaction
extends AbstractReactiveTransaction
implements RxTransaction {
    public InternalRxTransaction(UnmanagedTransaction tx) {
        super(tx);
    }

    @Override
    public RxResult run(Query query) {
        return new InternalRxResult(() -> {
            CompletableFuture cursorFuture = new CompletableFuture();
            this.tx.runRx(query).whenComplete((cursor, completionError) -> {
                if (cursor != null) {
                    cursorFuture.complete(cursor);
                } else {
                    Throwable error = Futures.completionExceptionCause(completionError);
                    this.tx.markTerminated(error);
                    cursorFuture.completeExceptionally(error);
                }
            });
            return cursorFuture;
        });
    }
}

