/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.reactive.AbstractReactiveTransaction;
import org.neo4j.driver.internal.reactive.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactive.InternalReactiveResult;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveTransaction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class InternalReactiveTransaction
extends AbstractReactiveTransaction
implements ReactiveTransaction,
BaseReactiveQueryRunner {
    protected InternalReactiveTransaction(UnmanagedTransaction tx) {
        super(tx);
    }

    @Override
    public Publisher<ReactiveResult> run(Query query) {
        CompletionStage<RxResultCursor> cursorStage;
        try {
            cursorStage = this.tx.runRx(query);
        }
        catch (Throwable t) {
            cursorStage = Futures.failedFuture(t);
        }
        return Mono.fromCompletionStage(cursorStage).flatMap(cursor -> {
            Mono publisher;
            Throwable runError = cursor.getRunError();
            if (runError != null) {
                publisher = Mono.error((Throwable)runError);
                this.tx.markTerminated(runError);
            } else {
                publisher = Mono.just((Object)cursor);
            }
            return publisher;
        }).map(InternalReactiveResult::new);
    }

    public Publisher<Void> interrupt() {
        return Mono.fromCompletionStage(this.tx.interruptAsync());
    }
}

