/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v41;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.cursor.ResultCursorFactoryImpl;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.spi.Connection;

public class BoltProtocolV41
extends BoltProtocolV4 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 1);
    public static final BoltProtocol INSTANCE = new BoltProtocolV41();

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV4();
    }

    @Override
    protected ResultCursorFactory buildResultCursorFactory(Connection connection, Query query, BookmarksHolder bookmarksHolder, UnmanagedTransaction tx, RunWithMetadataMessage runMessage, long fetchSize) {
        CompletableFuture<Void> runFuture = new CompletableFuture<Void>();
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR, connection, tx);
        PullAllResponseHandler pullAllHandler = PullHandlers.newBoltV4AutoPullHandler(query, runHandler, connection, bookmarksHolder, tx, fetchSize);
        PullResponseHandler pullHandler = PullHandlers.newBoltV4BasicPullHandler(query, runHandler, connection, bookmarksHolder, tx);
        return new ResultCursorFactoryImpl(connection, runMessage, runHandler, runFuture, pullHandler, pullAllHandler);
    }

    @Override
    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

