/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.io.IOException;
import java.util.Collections;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageEncoder;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.request.RouteMessage;
import org.neo4j.driver.internal.util.Preconditions;

public class RouteMessageEncoder
implements MessageEncoder {
    @Override
    public void encode(Message message, ValuePacker packer) throws IOException {
        Preconditions.checkArgument(message, RouteMessage.class);
        RouteMessage routeMessage = (RouteMessage)message;
        packer.packStructHeader(3, message.signature());
        packer.pack(routeMessage.getRoutingContext());
        packer.pack(routeMessage.getBookmark().isPresent() ? Values.value(routeMessage.getBookmark().get().values()) : Values.value(Collections.emptyList()));
        packer.pack(routeMessage.getDatabaseName());
    }
}

