/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Preconditions;

public class TransactionConfig {
    private static final TransactionConfig EMPTY = TransactionConfig.builder().build();
    private final Duration timeout;
    private final Map<String, Value> metadata;

    private TransactionConfig(Builder builder) {
        this.timeout = builder.timeout;
        this.metadata = Collections.unmodifiableMap(builder.metadata);
    }

    public static TransactionConfig empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Map<String, Value> metadata() {
        return this.metadata;
    }

    public boolean isEmpty() {
        return this.timeout == null && (this.metadata == null || this.metadata.isEmpty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionConfig that = (TransactionConfig)o;
        return Objects.equals(this.timeout, that.timeout) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.timeout, this.metadata);
    }

    public String toString() {
        return "TransactionConfig{timeout=" + this.timeout + ", metadata=" + this.metadata + '}';
    }

    public static class Builder {
        private Duration timeout;
        private Map<String, Value> metadata = Collections.emptyMap();

        private Builder() {
        }

        public Builder withTimeout(Duration timeout) {
            Objects.requireNonNull(timeout, "Transaction timeout should not be null");
            Preconditions.checkArgument(!timeout.isZero(), "Transaction timeout should not be zero");
            Preconditions.checkArgument(!timeout.isNegative(), "Transaction timeout should not be negative");
            this.timeout = timeout;
            return this;
        }

        public Builder withMetadata(Map<String, Object> metadata) {
            Objects.requireNonNull(metadata, "Transaction metadata should not be null");
            this.metadata = Extract.mapOfValues(metadata);
            return this;
        }

        public TransactionConfig build() {
            return new TransactionConfig(this);
        }
    }
}

